package JSR.Events;
/**
 * Classe che incapsula i dettagli di un evento riguardante un Servizio
 * @author Mattia Righini Mat 170738
 */
public class ServiceChangeEvent {
	//	Possibili valori dell'intero che rappresenta che tipo di evento si  verificato
    /**
     * Valore corrispondente all'aggiuta di un nuovo servizio.
     */
	public static int SERVICE_ADDED=1;
	/**
	 * Valore corrispondente alla rimozione di un servizio.
	 */
	public static int SERVICE_REMOVED=2;
    /**
     * Valore corrispondente al cambiamento di stato di un servizio.
     */
    public static int SERVICE_CHANGED=4;
    /**
     * Comment for <code>serviceName</code> Nome del servizio interessato dall'evento.
     */
    protected String serviceName;
    /**
     * Comment for <code>event</code> Tipo di evento.
     */
    protected int event;
    /**
     * Costruttore
     * @param serviceName Nome del servizio interessato dall'evento.
     * @param event Tipo di evento verificatosi
     */
    public ServiceChangeEvent(String serviceName,int event)
    {
        this.serviceName=serviceName;
        this.event=event;
    }    
    /**
     * Metodo per ottenere il nome del servizio interessato dall'evento.
     * @return Nome del servizio interessato dall'evento.
     */
    public String getServiceName(){return serviceName;}
    /**
     * Metodo per ottenere il tipo di evento verificatosi.
     * @return Tipo di evento verificatosi.
     */
    public int getEvent(){return event;}
}
