package JSR.Events;
import JSR.Account;
/**
 * Classe che incapsula i dettagli di un evento riguardante un Account.
 * @author Mattia Righini Mat 170738
 */
public class AccountsStateChangeEvent {
	//Possibili valori dell'intero che rappresenta che tipo di evento si  verificato
    /**
     * Valore corrispondente ad un login
     */
    public static int ACCOUNT_LOGIN=1;
    /**
     * Valore corrispondente ad un logout
     */    
    public static int ACCOUNT_LOGOUT=2;
    /**
     * Valore corrispondente all'aggiornamento dello "stato" dell'account,
     * ad esempio quando l'account ottiene o rilascia un lock.
     */    
    public static int ACCOUNT_UPDATE=4;
    
    protected Account account;
    protected int event;
    /**
     * Costruttore
     * @param a Account interessato dall'evento 
     * @param event Tipo di evento
     */
    public AccountsStateChangeEvent(Account a,int event)
    {
        this.account=a;
        this.event=event;
    }
    /**
     * Metodo per ottenere l'Account interessato dall'evento
     * @return Account interessato dall'evento
     */
    public Account getAccount(){return account;}
    /**
     * Metodo per ottenere il tipo di evento.
     * @return Intero che rappresenta il tipo di evento verificatosi.
     */
    public int getEventType(){return event;}
    /**
     * Verifica se l'evento  un evento di Login
     * @return true se l'evento  di login false altrimenti
     */
    public boolean Added(){return event==ACCOUNT_LOGIN;}
    /**
     * Verifica se l'evento  un evento di Logout
     * @return true se l'evento  di logout false altrimenti
     */
    public boolean Removed(){return event==ACCOUNT_LOGOUT;}
    /**
     * Verifica se l'evento  un evento di Update
     * @return true se l'evento  di update false altrimenti
     */
    public boolean Updated(){return event==ACCOUNT_UPDATE;}
}
