package JSR;
import java.util.Vector;

import JSR.Events.DebugListener;

/**
 * <p>Classe che mantiene le impostazioni globali.
 * @author Mattia Righini Mat 170738
 */
public class Configuration {
    protected static Vector debugListeners=null;
	/**
	 * Metodo per visualizzare un messaggio di Debug
	 * @param s Messaggio da visualizzare
	 */
	public static void DebugOutput(String s)
	{
		if(DEBUG &&(debugListeners!=null))
		{
		    for(int i=0;i<debugListeners.size();i++)
		        ((DebugListener)debugListeners.get(i)).printDebugString(s);
		}
	}
	/**
	 * Metodo per aggiungere un "Dispositivo di Debug" sul quale verranno visualizzati
	 * i messaggi di Debug.
	 * @param d Oggetto che implemente l'interfaccia {@link DebugListener DebugListener}.
	 */
	public static void addDebugListener(DebugListener d)
	{
	    if(debugListeners==null)debugListeners=new Vector();
	    debugListeners.add(d);
	}
	/**
	 * Booleano che indica se devono o meno essere mostrati i messaggi di output.
	 */
	public static boolean DEBUG=false;
	/**
	 * Millisecondi entro i quali un account deve inviare richieste, al termine di questo tempo l'account viene invalidato e viene eseguito un logOut forzato.
	 */
	public static int SESSIONTIMEOUT=1200000;
}
