package JSR;

import java.io.Serializable;

/**
 * <p>Classe che rappresenta un account attivo presso un IServiceBroker, per ottenere un account valido 
 * chiamare {@link JSR.IServiceBroker#logIn(String) IServiceBroker.logIn()}.
 * @author Mattia Righini Mat 170738
 */
public class Account implements Serializable {
	
	/**
	 * Comment for <code>seed</code> numero intero casuale generato dal Broker al momento del login, usato per 
	 * verificare la validit di un account.
	 */
	protected int seed;
	protected String accountId;
	/**
	 * Comment for <code>basePriority</code> Priorit base assegnata dal Broker all'account.
	 */
	protected int basePriority;
	/**
	 * Comment for <code>permissionsMask</code> Maschera per operazioni di verifica dei permessi legati all'account.
	 */
	protected int permissionsMask;
	/**
	 * Comment for <code>refManager</code> IReplicationManager di riferimento per l'account, viene usato
	 * dai provider quando vengono attivati e identificano un lock.
	 */
	protected IReplicationManager refManager;
	public Account(String id,int seed,int basePriority,int permissionMask,IReplicationManager refManager)
	{
		this.accountId=id;
		this.seed=seed;
		this.basePriority=basePriority;
		this.permissionsMask=permissionMask;
		this.refManager=refManager;
	}
	public boolean equals(Account a)
	{
		return ((accountId.equals(a.accountId))&&(seed==a.seed)&&(refManager.equals(a.refManager)));
	}
	/**
	 * Metodo per ottenere il ReplicationManager legato al ServiceBroker che ha generato l'account.
	 * @return ReplicationManager legato al ServiceBroker che ha generato l'account.
	 */
	public IReplicationManager getRefManager(){return refManager;}
	/**
	 * Metodo per ottenere l'id dell'Account
	 * @return Id Account
	 */
	public String getAccountId(){return accountId;}
	/**
	 * Metodo per ottenere la priorit base associata all'Account.
	 * @return Priorit base dell'Account.
	 */
	public int getBasePriority(){return basePriority;}
	public String toString()
	{
		return "Account Id="+accountId+" Seed="+seed+" BasePriority="+basePriority;
	}
    /**
     * Metodo per ottenere la maschera di verifica dei permessi.
     * @return maschera di verifica dei permessi legata all'account
     */
    public int getPermissionsMask() {
        return permissionsMask;
    }
}