import java.io.BufferedReader;
import java.rmi.Naming;
import java.rmi.RemoteException;

import JSR.AReplicableService;
import JSR.Configuration;
import JSR.IReplicationManager;
import JSR.Interface;
import JSR.Method;
import JSR.Status;
/**
 * Realizzazione di un Servizio replicabile di Contatore.
 * @author Mattia Righini Mat 170738
 */
public class CounterService extends AReplicableService {  
    /**
     * Valore iniziale del contatore.
     */
    int initial;

    //Implementazioni delle funzioni astratte di AReplicableService
    public String getServiceName() {
        return "CounterService";
    }
    protected Interface buildInterface() {
        Interface ret=new Interface();
        java.lang.reflect.Method[] methods=this.getClass().getMethods();
        for(int i=0;i<methods.length;i++)
        {
            try{
                String methodName=methods[i].getName();
                if((methodName.equals("get"))||(methodName.equals("inc"))||(methodName.equals("reset")))
                    ret.addMethod(new Method(methodName,methods[i].getReturnType(),methods[i].getParameterTypes()));
            }catch(Exception e)
            {
                System.err.println(e.getMessage());
                System.exit(1);
            }
        }
        return ret;
    }
    protected Status buildInitialStatus() {
        return new CounterStatus(initial);
    }
    protected boolean needToRefreshStatusAfter(String methodName) {
        return ((methodName.equals("inc")) || (methodName.equals("reset")));
    }
    //Funzioni disponibili per Account Esterni
    /**
     * Restituisce il valore corrente del contatore.
     * @return Valore del contatore.
     */
    public int get()
    {
        return ((CounterStatus)serviceStatus).getCountValue();
    }
    /**
     * Riporta il contatore a 0
     */
    public void reset()
    {
        ((CounterStatus)serviceStatus).reset();
    }
    /**
     * Incrementa il Contatore di 1
     */
    public void inc()
    {
        ((CounterStatus)serviceStatus).inc();
    }    
    /**
     * Cotruttore.
     * @param initial valore iniziale del contatore
     * @throws RemoteException
     */
    public CounterService(int initial)throws RemoteException
    {
        super();
        this.initial=initial;
    }
    
    public static void main(String[] args){
        if(args.length<2)
        {
            System.out.println("Uso CounterService <debug> <Broker1> [<Broker2> .. <BrokerN>]");
            System.out.println("debug booleano, true messaggi di debug visualizzati");
            System.exit(1);
        }
        Configuration.DEBUG=args[0].toLowerCase().equals("true");
        if(Configuration.DEBUG)
            Configuration.addDebugListener(new JSR.Events.ConsoleDebug());
        if (System.getSecurityManager() == null)
        { 
            System.setSecurityManager(new java.rmi.RMISecurityManager());
        }
        try{
            CounterService counter=new CounterService(0);
            for(int i=1;i<args.length;i++)
            {
                try{
                    IReplicationManager manager=(IReplicationManager)Naming.lookup(args[i]);
                    counter.addReplicationManager(manager);
                }catch(Exception e)
                {System.err.println(e);}
            }
            if(counter.registerService())System.out.println("Servizio Registrato");
            else{
                System.out.println("Servizio NON Registrato");
                System.exit(1);
            }
            BufferedReader in=new BufferedReader(new java.io.InputStreamReader(System.in));
            boolean exit=true;
             char c='\0';
             do
             {
             	System.out.println("Premere Q per uscire");
             	try{c=in.readLine().toLowerCase().charAt(0);}
             	catch(Exception e){
             	    System.out.println("Errore sullo stdin, impossibile acquisire caratteri il servizio rimarr aperto");
             	    exit=false;
             	    break;
             	}
             }while(c!='q');
             if(exit){
                 counter.unRegisterService();
                 System.exit(0);
             }
        }catch(RemoteException e)
        {
            System.err.println(e);
            System.exit(1);
        }
    }
}
/**
 * Classe che implementa lo stato del Contatore.
 * @author Mattia Righini Mat 170738
 */
class CounterStatus extends Status
{
    /**
     * Valore del contatore
     */
    protected int count;
    /**
     *Costruttore, Valore iniziale=0 
     */
    public CounterStatus()
    {
        this(0);
    }
    /**
     * Costruttore, Valore iniziale=initial
     * @param initial Valore iniziale.
     */
    public CounterStatus(int initial)
    {
        super();
        count=initial;
    }
    /**
     * Restituisce il valore corrente del contatore.
     * @return Valore corrente.
     */
    public int getCountValue(){return count;}
    /**
     * Riporta il contatore a 0
     */
    public void reset(){count=0;}
    /**
     * Inrementa il contatore di 1.
     */
    public void inc(){count++;}
	public String toString()
	{
	    String ret=super.toString();
	    ret+="\nCountValue="+count;
	    return ret;
	}
}