/*
 * TestMessageXML.java
 *
 * Created on 4 marzo 2004, 23.48
 */

package test;
import qms.messages.*;
import java.io.*;
import java.net.*;
/**
 * Test per QMS
 * @author  Enrico
 */
public class TestMessageSerialize {
    
    
    public static void main(String[] a) {
        try {
            CoordinationMessage msg = new CoordinationMessage("node1","node2","coda1","post_message");
            msg.setInnerMessage( new Message("me","te","coda1","CIAO"));
            
            
            System.out.println(msg);
            System.out.println("Come XML:");
            System.out.println(msg.asXML());
            
            
            
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            msg.serialize(out);
            
            InputStream in = new ByteArrayInputStream(out.toByteArray());
            int c = in.read();
            while (c != -1) {
                char h = (char) c;
                System.out.print(h);
                c = in.read();
            }
            
            Message read = MessageFactory.decodeMessage( new ByteArrayInputStream(out.toByteArray()));
            System.out.println("Decoded:\n"+read.asXML());
            
        } catch (Throwable t) {
            t.printStackTrace();
        }
    }
    
}
