<%@page contentType="text/html" import ="qms.group.*,qms.queue.*,java.util.*,qms.messages.*"%>
<%@page pageEncoding="UTF-8"%>
<html>
<%@include file="head.jsp" %>

<h1>Queues</h1>
<p>By means of this page you can see that status of each queue in the system</p>
<p>for each queue it is reported:
<ol>
<li>The name</li>
<li>Whether it is locked by this local node</li>
<li>The content of the <i>stack</i> (the ordered list of coordination messages to be processed for the queue)</li>
<li>The actual content of the <i>queue</i></li>
</ol>
</p>
<%
    Controller controller = Controller.getLocalInstance();
    Node local_node = Node.getLocalNode();    
    QueuesManager queues = controller.getQueues();
    Iterator queue_names = queues.queueNames();
    
    String action = request.getParameter("action");
    if (action == null) action ="none";
    
    while (queue_names.hasNext()) {
          String qid = (String) queue_names.next();
          MessageQueue q = queues.getQueue(qid);          
          Message[] stack = q.getStack().getSnapshot();
          Object[] messages = q.getMessages().toArray();
%>
<br>
<hr>

<FONT COLOR="RED">Queue name: <%=q.getId()%></font> <br>
Status: <%=q.isLocked()?"Locked":"Not Locked"%>

<br>
Stack:
<table bgcolor="#33CC33">
<%
    for (int i= 0; i < stack.length; i++) {
%>
    <tr><td><%=stack[i]%></td></tr>
<%
    }
%>
</table>

<br>
Messages:
<table bgcolor="#EECC33">
<%
    for (int i= 0; i < messages.length; i++) {
%>
    <tr><td><%=messages[i]%></td></tr>
<%
    }
%>
</table>

<%
}
%>


</body>
</html>
