/*
 * Logger.java
 *
 * Created on 16 marzo 2004, 19.52
 */

package qms.util;
import java.io.*;

/**
 * Mini libreria per il log su file di testo
 * @author  Enrico
 */
public class Logger {
    
    protected static String name = "unnamed";
    protected static PrintStream out = System.out;
    
    public static void init(String n) throws IOException { 
        name = n.replaceAll("/","_").replaceAll("\\\\","_"); 
        String file = "qms_"+name+".txt";
        
        out = new PrintStream(new FileOutputStream(file,true));        
        out.println("Logger started "+new java.util.Date());
    }    
    public static void close() {
        if (out != System.out) {
            if (out != null) {
                out.close();
            }
        }
    }
    
    public static void log(Object o) {
        out.println(name+":"+o);        
        if (o instanceof Throwable) {
               Throwable t = (Throwable) o;
               for (int i = 0; i < t.getStackTrace().length; i++) {
                   StackTraceElement el = t.getStackTrace()[i];
                   out.println(name+":"+el);        
               }
        }
        out.flush();
    }
}
