/*
 * LockQueueAction.java
 *
 * Created on 26 marzo 2004, 13.37
 */

package qms.queue.actions;
import qms.queue.*;
import qms.group.*;
import qms.util.*;
import qms.messages.*;
/**
 * Rilascio della ownership su di una coda
 * @author  Enrico
 */
public class UnlockQueueAction implements Action, WaitingAction, QueueLifeListener  {    
    
    protected String queueid;
    protected String lockid;
    protected Controller controller;
    protected boolean finished;
    protected boolean waiting;    
    
    public UnlockQueueAction(String queueid, String lockid, Controller controller) {
        this.queueid = queueid;
        this.lockid = lockid;
        this.controller = controller;
        this.finished = false;        
        this.waiting = true;
        controller.getQueues().getQueue(queueid).addQueueLifeListener(this);
    }
        
    public boolean isFinished() {
        return finished;
    }
    
    public void runStep() {
        if (waiting) return;
        
        if (finished) return;
        
        Message request_unlock = new Message( 
                    Node.getLocalNode().getName(),
                    Multicaster.ALL, 
                    queueid, 
                    "queue_unlock", 
                    lockid);
        controller.getMulticaster().castMessage(request_unlock);
        
        finished = true;
    }
    public String toString() { return "unlock "+queueid+" id="+lockid; }
    
    public void canStart() {
        waiting = false;
    }
    public void queueDestroyed(MessageQueue queue) {
        finished = true;
    }
    
    public void cancel() {
        finished = true;
    }
    
    public void notifyNodeRemoved(Node n) {
    }
    
}
