/*
 * Created on 26 marzo 2004, 13.37
 */

package qms.queue.actions;
import qms.queue.*;
import qms.group.*;
import qms.util.*;
import java.util.*;
import qms.messages.*;
/**
 * Dice a tutti i nodi del gruppo il nodo locale non vuole pi partecipare al gruppo
 * @author  Enrico
 */
public class SendWannaLeaveAction implements Action{
    
    
    protected Controller controller;
    protected boolean finished;    
    
    public SendWannaLeaveAction(Controller controller) {
        this.controller = controller;                
        this.finished = false;
    }
    
    public boolean isFinished() {                
        return finished;
    }
    
    public void runStep() {        
        if (finished) return;
        
                        
                Message cont = new Message(
                            Node.getLocalNode().getName(),
                            Multicaster.ALL,                            
                            QueuesManager.GROUP_QUEUE_ID,
                            "group_node_leave",
                            Node.getLocalNode().getAccessPoint().toString());                    
                                
                                
                controller.getMulticaster().castMessage(cont);                                
            
            
            finished = true;
    }
    public String toString() { return "group leaving"; }
        
            
    public void notifyNodeRemoved(Node n) {    
    }
}
