/*
 * LockQueueAction.java
 *
 * Created on 26 marzo 2004, 13.37
 */

package qms.queue.actions;
import qms.queue.*;
import qms.group.*;
import qms.util.*;
import qms.messages.*;
import java.util.*;
/**
 * Invia un messaggio di ping in broad cast, cos che il sotto-sistema di invio si accorga che un nodo  fallito
 * @author  Enrico
 */
public class PingGroupAction implements Action {
    
    protected Controller controller;
    protected int count;
    
    public PingGroupAction(Controller controller) {
        this.controller = controller;
        this.count = 0;
    }
    
    public boolean isFinished() {
        return false;
    }
    public void runStep() {
        if ( count == 2000) {
            Message m = new Message(Node.getLocalNode().getName(), Multicaster.ALL,QueuesManager.GROUP_QUEUE_ID,"group_ping","");
            controller.getMulticaster().castMessage(m);
            count = 0;
            
            try {
                for (Iterator n = controller.getGroup().iterator(); n.hasNext(); ) {
                    Node node = (Node) n.next();
                    if (node.getFaultCount() > 0) {
                        Logger.log("Node "+node+" should be banned!!");
                        Controller.getLocalInstance().banNode(node);
                    }
                }
            } catch (ConcurrentModificationException t) {}
        }
        
        count++;
    }
    public String toString() { return "check peers status (ping)"; }
    
    public void notifyNodeRemoved(Node n) {
    }
    
}
