/*
 * Created on 26 marzo 2004, 13.37
 */

package qms.queue.actions;
import qms.queue.*;
import qms.group.*;
import qms.util.*;
import java.util.*;
import qms.messages.*;
/**
 * Dice a tutti i nodi del gruppo che un nodo  da bandire dal gruppo
 * @author  Enrico
 */
public class InformNodeBannedAction implements Action {
    
    protected Node node;
    protected Controller controller;
    protected boolean finished;        
    
    public InformNodeBannedAction(Controller controller, Node node) {
        this.controller = controller;
        this.finished = false;
        this.node = node;                
    }
    
    public boolean isFinished() {        
        return finished;
    }
    
    public void runStep() {        
        if (finished) return;                    
        Logger.log("Executing InformNodeBannedAction for node "+node);
                Message cont = new Message(
                            node.getName(),
                            Multicaster.ALL,                            
                            QueuesManager.GROUP_QUEUE_ID,
                            "group_node_leave",
                            node.getAccessPoint().toString());                    
                                                
                controller.getMulticaster().castMessage(cont);
        Logger.log("Banner Message enqueued");            
            
            
        finished = true;
    }
    public String toString() { return "banning node "+node; }
    
            
    public void notifyNodeRemoved(Node n) {        
    }
}
