/*
 * NodeAccessPoint.java
 *
 * Created on 7 marzo 2004, 20.14
 */

package qms.io;
import qms.queue.*;
import qms.messages.*;
/**
 * Interfaccia di input per il nodo locale
 * @author  Enrico
 */
public class NodeAccessPoint {
        
    protected Controller manager;
    
    public NodeAccessPoint(Controller  manager) {        
        this.manager= manager;
    }
    /**
     * Trasporta un messaggio all'interno della libreria direttamente al metodo di Controller invocato dalle Servlet, serve per bypassare inutili chiamate HTTP per il nodo locale
     */
    public void messageReceived(Message m) {
        manager.messageReceived(m);
        m.notifyListener(true);
    }
}
