/*
 * Messenger.java
 *
 * Created on 5 marzo 2004, 0.22
 */

package qms.io;
import qms.messages.*;
import qms.util.*;
import qms.group.Node;
import java.io.*;
import java.net.*;
/**
 * Serve a spedire i messaggi
 * @author  Enrico
 */
public class Messenger {
        
    public Messenger() {
    }
    /**
     * Invia un messaggio ad un nodo. In caso di errore aumenta il faultCount del nodo
     */
    public boolean sendMessage(Message m, Node node) {                
        // aggiorniamo la rappresentazione interna del messaggio, nel caso sia cambiata..
        m.update();
        
        URL access_point = node.getAccessPoint();
        Logger.log("Sending msg:"+m+" to "+access_point);
        URLConnection con = null;
        OutputStream os = null;
        InputStream in = null;
        try {
            con = access_point.openConnection();
            con.setDoOutput(true);
            os = con.getOutputStream();
            m.serialize(os);
            in = con.getInputStream();
            BufferedReader liner = new BufferedReader(new InputStreamReader(in));
            String line = liner.readLine();
            while (line != null) {
                //Logger.log("received "+line);
                line = liner.readLine();
            }            
            m.notifyListener(true);
            return true;
        } catch (IOException io) {            
            Logger.log(io.getMessage());
            node.incFaultCount();
            m.notifyListener(false);
            return false;
        } finally {
            if (os != null) try { os.close(); } catch (IOException io) {}
            if (in != null) try { in.close(); } catch (IOException io) {}
        }
    }
}
