
package qms.group;
import qms.queue.*;
import qms.io.*;
import qms.util.*;
import java.io.*;
import java.net.*;
/**
 * Semplifica la configurazione del nodo locale
 * @author  Enrico
 */
public abstract class LocalNodeConfigurator {
    /**
     * Configura il nodo locale secondo il nome specificato dall'amminsitratore
     */
    public static void configurateLocalNode(String name) throws IOException {
        Node local = Node.getLocalNode();
        local.setName(name);        
        if (name.startsWith("/")) {
            local.setAccessPoint( new URL("http:/"+name+"CoordinationInterface"));
        } else {
            local.setAccessPoint( new URL("http://localhost/"+name+"/CoordinationInterface"));
        }
        
        Logger.init(name); 
               
        if ( Controller.getLocalInstance() == null)  {
            Group nodes = new Group();
            nodes.add(local);
            
            Controller.createLocalInstance(nodes);
            Controller planner = Controller.getLocalInstance();
            
            NodeAccessPoint sap = new NodeAccessPoint(planner);
            local.setLocalAccessPoint( sap);
                        
        }
        
    }
    
}
