package qms.group;
import java.util.*;
/**
 * Ci che rappresenta il gruppo in cui un nodo  inserito
 * @author  Enrico
 */
public class Group extends AbstractSet  {
    protected Set nodes;
        
    public Group() {
        reset();
    }
    /**
     * Cancella tutti i nodi
     */
    public void reset() {
        nodes = new TreeSet();
        nodes.add(Node.getLocalNode());
    }
    /**
     * Aggiunge un nodo
     */
    public void add(Node node) {
        nodes.add(node);
    }        
    /**
     * Iterazione su tutti i nodi
     */
    public java.util.Iterator iterator() {
        return nodes.iterator();
    }
    /**
     * Elimina un nodo dal gruppo   
     */
    public void removeByName(String name) {
        for (Iterator n = nodes.iterator(); n.hasNext();) {
            Node node = (Node) n.next();
            if (node.getName().equals(name)) {
                n.remove();
                break;
            }
        }
    }
    /**
     * Rimozione di un nodo dal gruppo
     */
    public void remove(Node node) {
        if (node != Node.getLocalNode()) 
                super.remove(node);
    }
    /**
     * Numero di nodi nel gruppo
     */
    public int size() {
        return nodes.size();
    }
    /**
     * ricerca di un nodo nel gruppo
     */
    public Node lookupNode(String name) {
        for (Iterator i = nodes.iterator(); i.hasNext();) {
            Node n = (Node) i.next();
            if (n.getName().equals(name)) return n;
        }
        return null;
    }
}
