/*
 * QMSClient.java
 *
 * Created on 25 marzo 2004, 15.50
 */

package qms.client;
import java.util.*;
import java.net.*;
import java.io.*;
import qms.messages.*;

/**
 * API di alto livello per l'accesso ad un cluster QMS
 * @author  Enrico
 */
public class QMSClient {
    
    protected URL access_point;
    protected String user;
    /**
     * Inizializza il client
     */
    public QMSClient() {
        access_point = null;
        this.user = "anonymous";
    }
    /**
     *  Imposta l'utente mittente di tutti i messaggi
     **/
    public void setUser(String user) {
        this.user = user;
    }
    /**
     * Imposta il punto di accesso del gruppo (la UserIterface di un nodo qualsiasi)
     */
    public void setAccessPoint(URL access_point) {
        this.access_point = access_point;
    }
    /**
     * Metodo di interno di comunicazione con il gruppo
     */
    protected Message sendMessage(Message m) throws QMSException {
        if (access_point == null) {
            throw new QMSException("Access point not set");            
        }
        // aggiorniamo la rappresentazione interna del messaggio, nel caso sia cambiata..
        m.update();                        
        URLConnection con = null;
        OutputStream os = null;
        InputStream in = null;
        try {
            con = access_point.openConnection();
            con.setDoOutput(true);
            os = con.getOutputStream();
            m.serialize(os);
            in = con.getInputStream();
            /*
            BufferedReader liner = new BufferedReader(new InputStreamReader(in));
            String line = liner.readLine();
            while (line != null) {                
                System.out.println(line);
                line = liner.readLine();                
            } */           
            
            Message response = MessageFactory.decodeMessage(in);
            return response;                        
            
        } catch (IOException io) {
            io.printStackTrace();  
            throw new QMSException("IOError while talking with SAP "+access_point,io);
        } finally {
            if (os != null) try { os.close(); } catch (IOException io) {}
            if (in != null) try { in.close(); } catch (IOException io) {}
        }
    }
  
    /**
     * Aggiunge un messaggio ad una coda
     */
    public void postMessage(String recipient, String queue_name, String body) throws QMSException {
        Message msg = new Message(user,recipient,queue_name,"user_post_message",body);
        sendMessage(msg);
    }
    /**
     * Cancella un messaggio dalla coda
     */
    public void deleteMessage(String queue_name, String msgid) throws QMSException {
        Message msg = new Message(user,"system",queue_name,"user_delete_message",msgid);
        sendMessage(msg);
    }
    /**
     * Richiede una lista di tutti i MessageID (String) dei messaggi
     **/
    public List listMessages(String queue_name) throws QMSException {
      Vector result = new Vector();
      Message msg = new Message(user,"system",queue_name,"user_list_messages","");
      Message response = sendMessage(msg);
      String body = response.getBody();
      StringTokenizer tok = new StringTokenizer(body,"\n");
      while (tok.hasMoreTokens()) {
          result.add(tok.nextToken());
      }
      return result;
    }
    /**
     * Richiede di cancellare una coda
     **/
    public void deleteQueue(String queue_name) throws QMSException {        
        Message msg = new Message(user,"any",queue_name,"user_delete_queue","");
        Message response = sendMessage(msg);
        System.out.println(response.asXML());
    }
    /**
     * Richiede di ottenere un messaggio da una coda
     **/
    public Message getMessage(String queue_name, String msgid) throws QMSException {
        Message msg = new Message(user,"any",queue_name,"user_get_message",msgid);
        return sendMessage(msg);
    }
}
