<%@page contentType="text/html" import ="qms.group.*,qms.queue.*,java.util.*"%>
<%@page pageEncoding="UTF-8"%>
<html>
<%@include file="head.jsp" %>

<h1>Node management</h1>

<%
    Controller controller = Controller.getLocalInstance();
    Node local_node = Node.getLocalNode();    
    Group nodes = controller.getGroup();    
    
    String action = request.getParameter("action");
    if (action == null) action ="none";
    
    if (action.equals("join_group")) {
        String sap = request.getParameter("sap")+"/CoordinationInterface";
        controller.requestJoin(sap);
    }
    if (action.equals("leave_group")) {        
        controller.leaveGroup();
    }
    if (action.equals("ban")) {
        String name = request.getParameter("name");
        Node n = nodes.lookupNode(name);        
        controller.banNode(n);
    }
%>
<br>
<table border="1" bgcolor="#CCCCC">
<tr><th colspan="2">Local node</th></tr>
<tr><th>Node name:</th><td><%=local_node.getName()%></td></tr>
<tr><th>Priority:</th><td><%=local_node.getPriority()%></td></tr>
<tr><th>Access Point:</th><td><%=local_node.getAccessPoint()%></td></tr>
<tr><th>Status:</th><td><%=controller.isFreezed()?"Freezed":"Working"%></td></tr>
</table>
<br>
<br>
<form action="node.jsp" method="get">
    <div>Join group</div>
    Access Point: <input type="text" name="sap" size="25" value="http://localhost/node1">/CoordinationInterface
    <input type="hidden" name="action" value="join_group">
    <input type="submit" value="Join">
</form>

<form action="node.jsp" method="get">    
    <input type="hidden" name="action" value="leave_group">
    <input type="submit" value="Leave">
</form>

<br>
<br>

<table border="1" bgcolor="#CCCCC">
<tr><th colspan="5" align="center">Nodes in group</th></tr>
<tr><td>Name</td><td>Priority</td><td>Access Point</td><td></td><td></td></tr>
<%
    for (Iterator i = nodes.iterator(); i.hasNext(); ) {
        Node n = (Node) i.next();
%>
<tr><td><%=n.getName()%></td><td><%=n.getPriority()%></td><td><%=n.getAccessPoint()%></td><td><a href="node.jsp?action=ban&name=<%=n.getName()%>">Ban</a></td><td></td></tr>
<%
    }
%>
</table>


</body>
</html>
