/*
 * Decompiled with CFR 0.152.
 */
package qms.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DOMUtils
implements ErrorHandler {
    public static Document newDocument() {
        try {
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = fact.newDocumentBuilder();
            Document doc = builder.newDocument();
            return doc;
        }
        catch (Exception e) {
            throw new IllegalStateException("Configurazione XML non corretta:" + e);
        }
    }

    public static Document parseStream(InputStream in) throws IOException {
        try {
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = fact.newDocumentBuilder();
            builder.setErrorHandler(new DOMUtils());
            return builder.parse(in);
        }
        catch (ParserConfigurationException pe) {
            throw new IllegalStateException("Libreria XML configurata male:" + pe);
        }
        catch (SAXException pe) {
            throw new IOException("Errore durante la lettura del documento XML:" + pe);
        }
    }

    public static void serialize(Document doc, OutputStream out) throws IOException {
        try {
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            if (doc == null) {
                throw new IOException("Documento DOM XML nullo");
            }
            DOMSource ds = new DOMSource(doc);
            StreamResult sr = new StreamResult(out);
            trans.transform(ds, sr);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new IllegalStateException("Libreria XML configurata male:" + e);
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalStateException("Libreria XML configurata male:" + e);
        }
        catch (TransformerException e) {
            throw new IllegalStateException("Errore durante la scrittura del documento XML:" + e);
        }
    }

    public static String asString(Document doc) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DOMUtils.serialize(doc, out);
            return new String(out.toByteArray());
        }
        catch (Throwable t) {
            return "Error while converting DOM to string " + t;
        }
    }

    public static void copyTree(Document parent_owner, Element parent, Element external_element_root) throws DOMException {
        String ns = external_element_root.getNamespaceURI();
        Element copy = null;
        copy = ns != null ? parent_owner.createElementNS(ns, external_element_root.getTagName()) : parent_owner.createElement(external_element_root.getTagName());
        NamedNodeMap nnm = external_element_root.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            Attr a = (Attr)nnm.item(i);
            copy.setAttribute(a.getNodeName(), a.getNodeValue());
        }
        if (parent == null) {
            parent = copy;
            parent_owner.appendChild(parent);
        } else {
            parent.appendChild(copy);
        }
        NodeList childs = external_element_root.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node n = childs.item(i);
            if (n instanceof Element) {
                DOMUtils.copyTree(parent_owner, copy, (Element)n);
                continue;
            }
            if (!(n instanceof Text)) continue;
            copy.appendChild(parent_owner.createTextNode(n.getNodeValue()));
        }
    }

    public void error(SAXParseException exception) throws SAXException {
        System.out.println("SAX Exception:" + exception);
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        System.out.println("SAX Error :" + exception);
    }

    public void warning(SAXParseException exception) throws SAXException {
        System.out.println("SAX Warning:" + exception);
    }
}

