/*
 * Decompiled with CFR 0.152.
 */
package qms.queue.actions;

import qms.group.Multicaster;
import qms.group.Node;
import qms.messages.Message;
import qms.messages.MessageQueue;
import qms.messages.QueueLifeListener;
import qms.queue.Controller;
import qms.queue.actions.Action;
import qms.queue.actions.WaitingAction;

public class UnlockQueueAction
implements Action,
WaitingAction,
QueueLifeListener {
    protected String queueid;
    protected String lockid;
    protected Controller controller;
    protected boolean finished;
    protected boolean waiting;

    public UnlockQueueAction(String queueid, String lockid, Controller controller) {
        this.queueid = queueid;
        this.lockid = lockid;
        this.controller = controller;
        this.finished = false;
        this.waiting = true;
        controller.getQueues().getQueue(queueid).addQueueLifeListener(this);
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void runStep() {
        if (this.waiting) {
            return;
        }
        if (this.finished) {
            return;
        }
        Message request_unlock = new Message(Node.getLocalNode().getName(), Multicaster.ALL, this.queueid, "queue_unlock", this.lockid);
        this.controller.getMulticaster().castMessage(request_unlock);
        this.finished = true;
    }

    public String toString() {
        return "unlock " + this.queueid + " id=" + this.lockid;
    }

    public void canStart() {
        this.waiting = false;
    }

    public void queueDestroyed(MessageQueue queue) {
        this.finished = true;
    }

    public void cancel() {
        this.finished = true;
    }

    public void notifyNodeRemoved(Node n) {
    }
}

