/*
 * Decompiled with CFR 0.152.
 */
package qms.queue.actions;

import qms.group.Multicaster;
import qms.group.Node;
import qms.messages.Message;
import qms.messages.MessageListener;
import qms.queue.Controller;
import qms.queue.actions.Action;
import qms.queue.actions.WaitingAction;
import qms.util.Logger;

public class UnFreezeGroupAction
implements Action,
MessageListener,
WaitingAction {
    protected Controller controller;
    protected boolean finished;
    protected boolean started;
    protected boolean waiting;
    protected int sent_count;
    protected int required_count;
    protected WaitingAction waiter;

    public UnFreezeGroupAction(Controller controller, WaitingAction waiter) {
        this.controller = controller;
        this.finished = false;
        this.waiter = waiter;
        this.sent_count = 0;
        this.required_count = controller.getGroup().size();
        this.started = false;
        this.waiting = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void runStep() {
        if (this.waiting) {
            return;
        }
        if (this.finished) {
            return;
        }
        if (!this.started) {
            this.started = true;
            Logger.log("Sending group_ready to every node. I have got " + this.controller.getGroup().size() + " peers");
            Message cont = new Message(Node.getLocalNode().getName(), Multicaster.ALL, "group", "group_ready", "");
            cont.setListener(this);
            this.controller.getMulticaster().castMessage(cont);
        }
    }

    public String toString() {
        return "unfreeze group";
    }

    public void notifyMessageDelivered(Message who, boolean status) {
        if (status) {
            ++this.sent_count;
        } else {
            --this.required_count;
        }
        if (this.sent_count == this.required_count) {
            this.finished = true;
            this.waiter.canStart();
        }
    }

    public void canStart() {
        this.waiting = false;
    }

    public void cancel() {
        this.finished = true;
        this.waiter.cancel();
    }

    public void notifyNodeRemoved(Node n) {
    }
}

