/*
 * Decompiled with CFR 0.152.
 */
package qms.queue.actions;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import qms.group.Multicaster;
import qms.group.Node;
import qms.messages.Message;
import qms.queue.Controller;
import qms.queue.actions.Action;
import qms.util.Logger;

public class PingGroupAction
implements Action {
    protected Controller controller;
    protected int count;

    public PingGroupAction(Controller controller) {
        this.controller = controller;
        this.count = 0;
    }

    public boolean isFinished() {
        return false;
    }

    public void runStep() {
        if (this.count == 2000) {
            Message m = new Message(Node.getLocalNode().getName(), Multicaster.ALL, "group", "group_ping", "");
            this.controller.getMulticaster().castMessage(m);
            this.count = 0;
            try {
                Iterator n = this.controller.getGroup().iterator();
                while (n.hasNext()) {
                    Node node = (Node)n.next();
                    if (node.getFaultCount() <= 0) continue;
                    Logger.log("Node " + node + " should be banned!!");
                    Controller.getLocalInstance().banNode(node);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
        ++this.count;
    }

    public String toString() {
        return "check peers status (ping)";
    }

    public void notifyNodeRemoved(Node n) {
    }
}

