/*
 * Decompiled with CFR 0.152.
 */
package qms.queue.actions;

import qms.group.Multicaster;
import qms.group.Node;
import qms.messages.Message;
import qms.messages.MessageQueue;
import qms.messages.QueueLifeListener;
import qms.queue.Controller;
import qms.queue.actions.Action;
import qms.queue.actions.WaitingAction;
import qms.util.Logger;

public class LockQueueAction
implements Action,
QueueLifeListener {
    protected String queueid;
    protected Controller controller;
    protected boolean finished;
    protected int status;
    protected WaitingAction waiter;
    protected String lockid;

    public LockQueueAction(String queueid, String lockid, Controller controller, WaitingAction waiter) {
        this.lockid = lockid;
        this.queueid = queueid;
        this.controller = controller;
        this.finished = false;
        this.status = 0;
        this.waiter = waiter;
        controller.getQueues().getQueue(queueid).addQueueLifeListener(this);
    }

    public boolean isFinished() {
        return this.finished;
    }

    protected void checkFinished() {
        MessageQueue queue = this.controller.getQueues().getQueue(this.queueid);
        if (queue.checkAndAcquireLock(this.lockid)) {
            this.finished = true;
            Logger.log("Lock acquired on queue " + this.queueid);
            this.waiter.canStart();
        }
    }

    public void runStep() {
        if (this.status == 0) {
            Message request_lock = new Message(Node.getLocalNode().getName(), Multicaster.ALL, this.queueid, "queue_request_lock", this.lockid);
            this.controller.getMulticaster().castMessage(request_lock);
            this.status = 1;
            return;
        }
        this.checkFinished();
    }

    public String toString() {
        return "lock " + this.queueid + " lockid=" + this.lockid;
    }

    public void queueDestroyed(MessageQueue queue) {
        this.finished = true;
    }

    public void notifyNodeRemoved(Node n) {
    }
}

