/*
 * Decompiled with CFR 0.152.
 */
package qms.queue.actions;

import qms.group.Multicaster;
import qms.group.Node;
import qms.messages.Message;
import qms.queue.Controller;
import qms.queue.actions.Action;
import qms.util.Logger;

public class InformNodeBannedAction
implements Action {
    protected Node node;
    protected Controller controller;
    protected boolean finished;

    public InformNodeBannedAction(Controller controller, Node node) {
        this.controller = controller;
        this.finished = false;
        this.node = node;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void runStep() {
        if (this.finished) {
            return;
        }
        Logger.log("Executing InformNodeBannedAction for node " + this.node);
        Message cont = new Message(this.node.getName(), Multicaster.ALL, "group", "group_node_leave", this.node.getAccessPoint().toString());
        this.controller.getMulticaster().castMessage(cont);
        Logger.log("Banner Message enqueued");
        this.finished = true;
    }

    public String toString() {
        return "banning node " + this.node;
    }

    public void notifyNodeRemoved(Node n) {
    }
}

