/*
 * Decompiled with CFR 0.152.
 */
package qms.queue.actions;

import qms.group.Multicaster;
import qms.group.Node;
import qms.messages.Message;
import qms.messages.MessageListener;
import qms.queue.Controller;
import qms.queue.actions.Action;
import qms.queue.actions.WaitingAction;

public class InformNewNodeExistanceAction
implements Action,
WaitingAction,
MessageListener {
    protected Node node;
    protected Controller controller;
    protected boolean finished;
    protected boolean sending_finished;
    protected boolean waiting;
    protected boolean started;
    protected int sent_count;
    protected int required_count;
    protected WaitingAction waiter;

    public InformNewNodeExistanceAction(Controller controller, Node node, WaitingAction waiter) {
        this.controller = controller;
        this.finished = false;
        this.node = node;
        this.waiting = true;
        this.waiter = waiter;
        this.sent_count = 0;
        this.sending_finished = false;
        this.required_count = controller.getGroup().size();
        this.started = false;
    }

    public boolean isFinished() {
        if (!this.finished && this.sending_finished && this.sent_count == this.required_count) {
            this.finished = true;
            this.waiter.canStart();
        }
        return this.finished;
    }

    public void runStep() {
        if (this.waiting) {
            return;
        }
        if (this.finished) {
            return;
        }
        if (!this.started) {
            this.sending_finished = false;
            this.started = true;
            this.required_count = 0;
            Message cont = new Message(this.node.getName(), Multicaster.ALL, "group", "group_node_exists", this.node.getAccessPoint().toString());
            cont.setListener(this);
            this.required_count = this.controller.getGroup().size();
            this.controller.getMulticaster().castMessage(cont);
            this.sending_finished = true;
        }
    }

    public String toString() {
        return "inform new node existance of " + this.node;
    }

    public void canStart() {
        this.waiting = false;
    }

    public void notifyMessageDelivered(Message who, boolean status) {
        if (status) {
            ++this.sent_count;
        } else {
            --this.required_count;
        }
    }

    public void cancel() {
        this.finished = true;
        this.waiter.cancel();
    }

    public void notifyNodeRemoved(Node n) {
        --this.required_count;
    }
}

