/*
 * Decompiled with CFR 0.152.
 */
package qms.queue.actions;

import qms.group.Multicaster;
import qms.group.Node;
import qms.messages.Message;
import qms.messages.MessageListener;
import qms.queue.Controller;
import qms.queue.actions.Action;
import qms.queue.actions.WaitingAction;

public class FreezeGroupAction
implements Action,
MessageListener {
    protected Controller controller;
    protected boolean finished;
    protected boolean started;
    protected int sent_count;
    protected int required_count;
    protected WaitingAction waiter;

    public FreezeGroupAction(Controller controller, WaitingAction waiter) {
        this.controller = controller;
        this.finished = false;
        this.waiter = waiter;
        this.sent_count = 0;
        this.required_count = controller.getGroup().size();
        this.started = false;
    }

    public boolean isFinished() {
        if (this.finished) {
            return true;
        }
        if (this.sent_count == this.required_count) {
            this.finished = true;
            this.waiter.canStart();
        }
        return this.finished;
    }

    public void runStep() {
        if (!this.started) {
            this.started = true;
            Message cont = new Message(Node.getLocalNode().getName(), Multicaster.ALL, "group", "group_freeze", "");
            cont.setListener(this);
            this.controller.getMulticaster().castMessage(cont);
        }
    }

    public String toString() {
        return "freeze group";
    }

    public void notifyMessageDelivered(Message who, boolean status) {
        if (status) {
            ++this.sent_count;
        } else {
            --this.required_count;
        }
    }

    public void notifyNodeRemoved(Node n) {
        --this.required_count;
    }
}

