/*
 * Decompiled with CFR 0.152.
 */
package qms.queue.actions;

import qms.group.Multicaster;
import qms.group.Node;
import qms.messages.Message;
import qms.messages.MessageListener;
import qms.messages.MessageQueue;
import qms.messages.QueueLifeListener;
import qms.queue.Controller;
import qms.queue.actions.Action;
import qms.queue.actions.WaitingAction;

public class DeleteMessageAction
implements Action,
WaitingAction,
MessageListener,
QueueLifeListener {
    protected String queueid;
    protected String msgid;
    protected Controller controller;
    protected boolean finished;
    protected boolean waiting;
    protected boolean started;
    protected int sent_count;
    protected int required_count;
    protected WaitingAction waiter;

    public DeleteMessageAction(String queueid, String msgid, Controller controller, WaitingAction waiter) {
        this.queueid = queueid;
        this.controller = controller;
        this.finished = false;
        this.msgid = msgid;
        this.waiting = true;
        this.waiter = waiter;
        this.sent_count = 0;
        this.required_count = controller.getGroup().size();
        this.started = false;
        controller.getQueues().getQueue(queueid).addQueueLifeListener(this);
    }

    public boolean isFinished() {
        if (this.finished) {
            return true;
        }
        if (this.sent_count >= this.required_count) {
            this.finished = true;
            this.waiter.canStart();
        }
        return this.finished;
    }

    public void runStep() {
        if (this.waiting) {
            return;
        }
        if (!this.started) {
            this.started = true;
            Message cont = new Message(Node.getLocalNode().getName(), Multicaster.ALL, this.queueid, "queue_delete_message", this.msgid);
            cont.setListener(this);
            this.controller.getMulticaster().castMessage(cont);
        }
    }

    public String toString() {
        return "delete (" + this.sent_count + "/" + this.required_count + ") msg " + this.msgid + " from queue " + this.queueid;
    }

    public void canStart() {
        this.waiting = false;
    }

    public void notifyMessageDelivered(Message who, boolean status) {
        if (status) {
            ++this.sent_count;
        }
    }

    public void queueDestroyed(MessageQueue queue) {
        this.finished = true;
    }

    public void cancel() {
        this.finished = true;
        this.waiter.cancel();
    }

    public void notifyNodeRemoved(Node n) {
        --this.required_count;
    }
}

