/*
 * Decompiled with CFR 0.152.
 */
package qms.queue.actions;

import java.util.Iterator;
import qms.group.Group;
import qms.group.Node;
import qms.messages.Message;
import qms.messages.MessageListener;
import qms.messages.MessageQueue;
import qms.messages.QueuesManager;
import qms.queue.Controller;
import qms.queue.actions.Action;
import qms.queue.actions.WaitingAction;

public class BulkCopyAction
implements Action,
WaitingAction,
MessageListener {
    protected Node node;
    protected Controller controller;
    protected boolean finished;
    protected boolean sending_finished;
    protected boolean waiting;
    protected boolean started;
    protected int sent_count;
    protected int required_count;
    protected WaitingAction waiter;

    public BulkCopyAction(Controller controller, Node node, WaitingAction waiter) {
        this.controller = controller;
        this.finished = false;
        this.node = node;
        this.waiting = true;
        this.waiter = waiter;
        this.sent_count = 0;
        this.required_count = -1;
        this.started = false;
    }

    public boolean isFinished() {
        if (!this.finished && this.sending_finished && this.sent_count == this.required_count) {
            this.finished = true;
            this.waiter.canStart();
        }
        return this.finished;
    }

    public void runStep() {
        if (this.waiting) {
            return;
        }
        if (!this.started) {
            this.sending_finished = false;
            this.started = true;
            this.required_count = 0;
            QueuesManager queues = this.controller.getQueues();
            Iterator i = queues.queueNames();
            while (i.hasNext()) {
                String qid = (String)i.next();
                MessageQueue queue = queues.getQueue(qid);
                Iterator j = queue.getMessages().iterator();
                while (j.hasNext()) {
                    if (this.finished) {
                        return;
                    }
                    Message msg = (Message)j.next();
                    Message cont = new Message(Node.getLocalNode().getName(), this.node.getName(), qid, "group_bulk_copy_message", msg.asXML());
                    cont.setListener(this);
                    ++this.required_count;
                    this.controller.getMulticaster().castMessage(cont, this.node);
                }
            }
            Group nodes = this.controller.getGroup();
            Iterator i2 = nodes.iterator();
            while (i2.hasNext()) {
                Node peer = (Node)i2.next();
                Message cont = new Message(peer.getName(), this.node.getName(), "group", "group_node_exists", peer.getAccessPoint().toString());
                cont.setListener(this);
                ++this.required_count;
                this.controller.getMulticaster().castMessage(cont, this.node);
            }
            this.sending_finished = true;
        }
    }

    public String toString() {
        return "bulk copy on " + this.node;
    }

    public void canStart() {
        this.waiting = false;
    }

    public void notifyMessageDelivered(Message who, boolean status) {
        if (status) {
            ++this.sent_count;
        } else {
            this.finished = true;
            this.waiter.cancel();
        }
    }

    public void cancel() {
        this.finished = true;
        this.waiter.cancel();
    }

    public void notifyNodeRemoved(Node n) {
    }
}

