/*
 * Decompiled with CFR 0.152.
 */
package qms.queue.actions;

import java.util.Iterator;
import java.util.List;
import qms.group.Group;
import qms.group.Node;
import qms.messages.Message;
import qms.messages.MessageQueue;
import qms.messages.QueuesManager;
import qms.queue.Controller;
import qms.queue.actions.Action;

public class AnswerLockRequestsAction
implements Action {
    protected Controller controller;

    public AnswerLockRequestsAction(Controller controller) {
        this.controller = controller;
    }

    public boolean isFinished() {
        return false;
    }

    public void runStep() {
        Group nodes = this.controller.getGroup();
        QueuesManager queues = this.controller.getQueues();
        Iterator i = queues.queueNames();
        while (i.hasNext()) {
            String qid = (String)i.next();
            MessageQueue q = queues.getQueue(qid);
            if (q.isLocked()) continue;
            List can_answer_agree_messages = q.findAgreeableLockMessages();
            Iterator a = can_answer_agree_messages.iterator();
            while (a.hasNext()) {
                Message m = (Message)a.next();
                String lockid = m.getBody();
                Node new_owner = nodes.lookupNode(m.getSender());
                q.addOwner(new_owner);
                Message agree = new Message(Node.getLocalNode().getName(), new_owner.getName(), q.getId(), "queue_agree_lock", lockid);
                this.controller.getMulticaster().castMessage(agree);
            }
        }
    }

    public String toString() {
        return "answer lock requests";
    }

    public void notifyNodeRemoved(Node n) {
    }
}

