/*
 * Decompiled with CFR 0.152.
 */
package qms.queue;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import qms.group.Group;
import qms.group.Multicaster;
import qms.group.Node;
import qms.messages.Message;
import qms.messages.MessageFactory;
import qms.messages.MessageQueue;
import qms.messages.QueuesManager;
import qms.queue.actions.Action;
import qms.queue.actions.ActionListener;
import qms.queue.actions.AnswerLockRequestsAction;
import qms.queue.actions.BulkCopyAction;
import qms.queue.actions.DeleteMessageAction;
import qms.queue.actions.FreezeGroupAction;
import qms.queue.actions.InformNewNodeExistanceAction;
import qms.queue.actions.InformNodeBannedAction;
import qms.queue.actions.LockQueueAction;
import qms.queue.actions.PingGroupAction;
import qms.queue.actions.PostMessageAction;
import qms.queue.actions.SendWannaLeaveAction;
import qms.queue.actions.UnFreezeGroupAction;
import qms.queue.actions.UnlockQueueAction;
import qms.queue.actions.WaitingAction;
import qms.util.Logger;

public class Controller
implements Runnable,
ActionListener {
    protected static Controller instance;
    public static final boolean DEBUG = true;
    protected Multicaster multicast;
    protected Group nodes;
    protected QueuesManager queues;
    protected Vector actions;
    protected Thread life;
    protected boolean stop;
    protected List freezed_messages;
    protected boolean freezed;

    public static void createLocalInstance(Group nodes) {
        instance = new Controller(nodes);
    }

    public static Controller getLocalInstance() {
        return instance;
    }

    public boolean isFreezed() {
        return this.freezed;
    }

    public List getFreezedMessages() {
        return new Vector(this.freezed_messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getActions() {
        Vector vector = this.actions;
        synchronized (vector) {
            return new Vector(this.actions);
        }
    }

    public Group getGroup() {
        return this.nodes;
    }

    public QueuesManager getQueues() {
        return this.queues;
    }

    public Multicaster getMulticaster() {
        return this.multicast;
    }

    protected Controller(Group nodes) {
        this.multicast = new Multicaster(nodes);
        this.nodes = nodes;
        this.queues = new QueuesManager(nodes);
        this.actions = new Vector();
        this.freezed_messages = new Vector();
        this.freezed = false;
        this.stop = false;
        this.life = new Thread(this);
        this.life.setName("Node Controller life thread");
        this.life.setDaemon(true);
        this.life.start();
        this.addAction(new AnswerLockRequestsAction(this));
        this.addAction(new PingGroupAction(this));
    }

    public void unfreeze() {
        this.freezeQueueMessages(false);
    }

    protected synchronized void freezeQueueMessages(boolean freeze) {
        if (freeze) {
            this.freezed = true;
        } else {
            this.freezed = false;
            Iterator i = this.freezed_messages.iterator();
            while (i.hasNext()) {
                Message m = (Message)i.next();
                i.remove();
                this.messageReceived(m);
            }
        }
    }

    protected synchronized void addAction(Action action) {
        this.actions.add(action);
    }

    protected boolean isGroupManagementMessage(Message cm) {
        String a = cm.getType();
        return a.equals("group_join_request") || a.equals("group_node_added") || a.equals("group_node_leave") || a.equals("group_ping") || a.equals("group_freeze") || a.equals("group_ready") || a.equals("group_node_exists") || a.equals("group_bulk_copy_message");
    }

    public void freezeGroup() {
        Message msg = new Message(Node.getLocalNode().getName(), Multicaster.ALL, "system", "group_freeze", "");
        this.multicast.castMessage(msg);
    }

    protected void scheduleMessagePosting(Message m) {
        String lockid = QueuesManager.createNewLockID();
        UnlockQueueAction unlock = new UnlockQueueAction(m.getQueueId(), lockid, this);
        PostMessageAction distribute = new PostMessageAction(m, this, unlock);
        LockQueueAction lock = new LockQueueAction(m.getQueueId(), lockid, this, distribute);
        this.addAction(lock);
        this.addAction(distribute);
        this.addAction(unlock);
    }

    protected void scheduleMessageDeletion(Message m) {
        String lockid = QueuesManager.createNewLockID();
        UnlockQueueAction unlock = new UnlockQueueAction(m.getQueueId(), lockid, this);
        DeleteMessageAction delete = new DeleteMessageAction(m.getQueueId(), m.getBody(), this, unlock);
        LockQueueAction lock = new LockQueueAction(m.getQueueId(), lockid, this, delete);
        this.addAction(lock);
        this.addAction(delete);
        this.addAction(unlock);
    }

    protected Message answerGetMessage(Message m) {
        MessageQueue q = this.queues.getQueue(m.getQueueId());
        Message result = q.getMessage(m.getBody());
        if (result == null) {
            result = new Message("system", m.getSender(), m.getQueueId(), "failure", "Message " + m.getBody() + " does not exists");
        }
        return result;
    }

    protected Message answerListMessages(Message m) {
        MessageQueue q = this.queues.getQueue(m.getQueueId());
        Message result = new Message("system", m.getSender(), m.getQueueId(), "messages_list", "");
        StringBuffer ids = new StringBuffer();
        Iterator i = q.getMessages().iterator();
        while (i.hasNext()) {
            Message ms = (Message)i.next();
            ids.append(ms.getId() + "\n");
        }
        result.setBody(ids.toString());
        return result;
    }

    public Message userMessageReceived(Message m) {
        String type = m.getType();
        Message response = new Message("system", m.getSender(), "system", "ok", "request received");
        if (type.equals("user_post_message")) {
            m.setType("user_msg");
            this.scheduleMessagePosting(m);
            return response;
        }
        if (type.equals("user_delete_message")) {
            this.scheduleMessageDeletion(m);
            return response;
        }
        if (type.equals("user_get_message")) {
            return this.answerGetMessage(m);
        }
        if (type.equals("user_list_messages")) {
            return this.answerListMessages(m);
        }
        if (type.equals("user_delete_queue")) {
            Message internal_delete_queue = new Message(Node.getLocalNode().getName(), Multicaster.ALL, "system", "system_delete_queue", m.getQueueId());
            this.scheduleMessagePosting(internal_delete_queue);
            return response;
        }
        response = new Message("system", m.getSender(), "system", "failure", "Bad request");
        return response;
    }

    public void messageReceived(Message m) {
        Logger.log("Message received:" + m);
        if (this.isGroupManagementMessage(m)) {
            this.dispatchGroupManagementMessage(m);
            return;
        }
        if (this.freezed) {
            this.freezed_messages.add(m);
            return;
        }
        if (this.isQueueManagementMessage(m)) {
            this.dispatchQueueManagementMessage(m);
            return;
        }
        this.dispatchUserRequest(m);
    }

    protected void scheduleNewNodeJoin(Message m) {
        try {
            String node_name = m.getSender();
            String node_sap = m.getBody();
            URL url = new URL(node_sap);
            Node newnode = new Node();
            newnode.setName(node_name);
            newnode.setAccessPoint(url);
            UnFreezeGroupAction unfreeze = new UnFreezeGroupAction(this, new WaitingAction(){

                public void canStart() {
                }

                public void cancel() {
                }
            });
            InformNewNodeExistanceAction inform = new InformNewNodeExistanceAction(this, newnode, unfreeze);
            BulkCopyAction bulk_copy = new BulkCopyAction(this, newnode, inform);
            FreezeGroupAction freeze = new FreezeGroupAction(this, bulk_copy);
            this.addAction(freeze);
            this.addAction(bulk_copy);
            this.addAction(inform);
            this.addAction(unfreeze);
        }
        catch (MalformedURLException e) {
            Logger.log("Impossibile aggiungere il nodo. Il suo Accessp Point non \u00e8 corretto");
            Logger.log(e);
        }
    }

    protected void newNodeExists(Message m) {
        String node_name = m.getSender();
        String sap = m.getBody();
        try {
            URL url = new URL(sap);
            Node n = new Node();
            n.setName(node_name);
            n.setAccessPoint(url);
            this.nodes.add(n);
        }
        catch (MalformedURLException e) {
            Logger.log(e);
        }
    }

    public void banNode(Node node) {
        Logger.log("System required me directly to ban " + node);
        if (node == null) {
            return;
        }
        this.notifyNodeBanned(node);
        this.scheduleBanNode(node);
    }

    protected void scheduleBanNode(Node node) {
        Logger.log("Scheduling Banning of node " + node);
        InformNodeBannedAction banner = new InformNodeBannedAction(this, node);
        this.addAction(banner);
    }

    public void leaveGroup() {
        Logger.log("Leaving group");
        SendWannaLeaveAction leaver = new SendWannaLeaveAction(this);
        this.addAction(leaver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyNodeBanned(Node n) {
        if (n == null) {
            return;
        }
        if (n != Node.getLocalNode()) {
            Logger.log("Removing " + n + " from group knowledge");
            this.nodes.remove(n);
            Logger.log("Notifying queues");
            this.queues.notifyNodeRemoved(n);
            Logger.log("Notifying actions");
            Vector vector = this.actions;
            synchronized (vector) {
                Iterator a = this.actions.iterator();
                while (a.hasNext()) {
                    Action action = (Action)a.next();
                    action.notifyNodeRemoved(n);
                }
            }
            Logger.log("Finished notifying..");
        }
    }

    protected void nodeBanned(Message m) {
        Logger.log("Processing node_leave " + m);
        try {
            String node_name = m.getSender();
            String sap = m.getBody();
            URL url = new URL(sap);
            Node n = new Node();
            n.setName(node_name);
            n.setAccessPoint(url);
            this.notifyNodeBanned(n);
        }
        catch (MalformedURLException e) {
            Logger.log(e);
        }
    }

    protected void bulkCopyMessage(Message m) {
        Logger.log("Received bulk copy msg");
        try {
            Message msg = MessageFactory.decodeMessage(m.getBody());
            Logger.log(msg);
            MessageQueue queue = this.queues.getQueue(msg.getQueueId());
            queue.addMessage(msg);
            Logger.log("Saved");
        }
        catch (IOException io) {
            Logger.log("troubles decoding bulk copy msg\n" + m.getBody());
            Logger.log(io);
        }
    }

    protected void dispatchGroupManagementMessage(Message m) {
        String type = m.getType();
        if (type.equals("group_freeze")) {
            this.freezeQueueMessages(true);
            return;
        }
        if (type.equals("group_ready")) {
            this.freezeQueueMessages(false);
            return;
        }
        if (type.equals("group_bulk_copy_message")) {
            this.bulkCopyMessage(m);
            return;
        }
        if (type.equals("group_join_request")) {
            this.scheduleNewNodeJoin(m);
            return;
        }
        if (type.equals("group_node_exists")) {
            this.newNodeExists(m);
            return;
        }
        if (type.equals("group_node_leave")) {
            this.nodeBanned(m);
            return;
        }
        Logger.log("Trascuro il messaggio di gestione del gruppo " + m);
    }

    protected void dispatchQueueManagementMessage(Message m) {
        Logger.log("Accetto il messaggio di gestione di una coda " + m);
        MessageQueue queue = this.queues.getQueue(m.getQueueId());
        queue.pushMessageOntoStack(m);
    }

    protected void dispatchUserRequest(Message m) {
        Logger.log("Trascuro il messaggio utente " + m);
    }

    protected boolean isQueueManagementMessage(Message cm) {
        String a = cm.getType();
        return a.equals("queue_request_lock") || a.equals("queue_agree_lock") || a.equals("queue_unlock") || a.equals("queue_delete_message") || a.equals("queue_post_message");
    }

    public void stop() {
        this.stop = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.stop) {
            try {
                Vector vector = this.actions;
                synchronized (vector) {
                    Iterator i = this.actions.iterator();
                    while (i.hasNext()) {
                        Action a = (Action)i.next();
                        try {
                            a.runStep();
                            if (!a.isFinished()) continue;
                            i.remove();
                        }
                        catch (Throwable t) {
                            Logger.log("Exception while handling action:" + a);
                            Logger.log(t);
                        }
                    }
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ie) {
                }
            }
            catch (Throwable t) {
                Logger.log(t);
            }
        }
    }

    public void actionFinished(Action action) {
    }

    public void requestJoin(String sap) throws MalformedURLException {
        this.freezeQueueMessages(true);
        Node tmp = new Node();
        URL url = new URL(sap);
        tmp.setName("unknown");
        tmp.setAccessPoint(url);
        Message request = new Message(Node.getLocalNode().getName(), tmp.getName(), "group", "group_join_request", Node.getLocalNode().getAccessPoint().toString());
        this.multicast.castMessage(request, tmp);
    }
}

