/*
 * Decompiled with CFR 0.152.
 */
package qms.messages;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import qms.group.Group;
import qms.group.Node;
import qms.messages.Message;
import qms.messages.MessageQueue;
import qms.messages.QueueListener;
import qms.util.Logger;

public class QueuesManager
implements QueueListener {
    protected Map queues = new HashMap();
    protected Group nodes;
    public static final String SYSTEM_QUEUE_ID = "system";
    public static final String GROUP_QUEUE_ID = "group";

    public QueuesManager(Group nodes) {
        this.nodes = nodes;
        this.createQueue(SYSTEM_QUEUE_ID).addListener(this);
    }

    public MessageQueue getQueue(String id) {
        MessageQueue result = (MessageQueue)this.queues.get(id);
        return this.createQueue(id);
    }

    public synchronized MessageQueue createQueue(String id) {
        MessageQueue result = (MessageQueue)this.queues.get(id);
        if (result != null) {
            return result;
        }
        MessageQueue queue = new MessageQueue(id, this.nodes);
        this.queues.put(id, queue);
        return queue;
    }

    public synchronized void deleteQueue(String id) {
        MessageQueue q = (MessageQueue)this.queues.get(id);
        if (q != null) {
            this.queues.remove(id);
            q.notifyQueueDestroyed();
        }
    }

    public Iterator queueNames() {
        return this.queues.keySet().iterator();
    }

    public void messageAdded(MessageQueue queue, Message msg) {
        if (queue.getId().equals(SYSTEM_QUEUE_ID) && msg.getType().equals("system_delete_queue")) {
            String qid = msg.getBody();
            Logger.log("Deleting queue " + qid);
            this.deleteQueue(qid);
            queue.removeMessage(msg.getId());
        }
    }

    public void messageRemoved(MessageQueue queue, Message msg) {
    }

    public static String createNewLockID() {
        return "lck" + System.currentTimeMillis();
    }

    public void notifyNodeRemoved(Node n) {
        Iterator i = this.queueNames();
        while (i.hasNext()) {
            String qid = (String)i.next();
            MessageQueue q = this.getQueue(qid);
            q.notifyNodeRemoved(n);
        }
    }
}

