/*
 * Decompiled with CFR 0.152.
 */
package qms.messages;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import qms.group.CoordinationMessagesStack;
import qms.group.Group;
import qms.group.Node;
import qms.messages.Message;
import qms.messages.MessageFactory;
import qms.messages.QueueLifeListener;
import qms.messages.QueueListener;
import qms.util.Logger;

public class MessageQueue {
    protected LinkedList messages;
    protected CoordinationMessagesStack stack;
    protected String queueId;
    protected Group nodes;
    protected boolean locked;
    protected Set listeners;
    protected Set life_listeners;
    protected Set owners;

    public String getId() {
        return this.queueId;
    }

    public MessageQueue(String queueId, Group nodes) {
        this.queueId = queueId;
        this.nodes = nodes;
        this.listeners = new HashSet();
        this.owners = new HashSet();
        this.life_listeners = new HashSet();
        this.messages = new LinkedList();
        this.stack = new CoordinationMessagesStack(nodes);
        this.locked = false;
    }

    public void addListener(QueueListener l) {
        this.listeners.add(l);
    }

    public void removeListener(QueueListener l) {
        this.listeners.remove(l);
    }

    public void addQueueLifeListener(QueueLifeListener l) {
        this.life_listeners.add(l);
    }

    public void removeQueueLifeListener(QueueLifeListener l) {
        this.life_listeners.remove(l);
    }

    public void notifyQueueDestroyed() {
        Iterator i = this.life_listeners.iterator();
        while (i.hasNext()) {
            QueueLifeListener l = (QueueLifeListener)i.next();
            try {
                l.queueDestroyed(this);
            }
            catch (Throwable t) {
                Logger.log(t);
            }
        }
    }

    public void notifyMessageAdded(Message m) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            QueueListener l = (QueueListener)i.next();
            try {
                l.messageAdded(this, m);
            }
            catch (Throwable t) {
                Logger.log(t);
            }
        }
    }

    public void notifyMessageRemoved(Message m) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            QueueListener l = (QueueListener)i.next();
            try {
                l.messageRemoved(this, m);
            }
            catch (Throwable t) {
                Logger.log(t);
            }
        }
    }

    public synchronized Message getMessage(String id) {
        Iterator i = this.messages.iterator();
        while (i.hasNext()) {
            Message m = (Message)i.next();
            if (!m.getId().equals(id)) continue;
            return m;
        }
        return null;
    }

    public synchronized Message extractMessage(String id) {
        Iterator i = this.messages.iterator();
        while (i.hasNext()) {
            Message m = (Message)i.next();
            if (!m.getId().equals(id)) continue;
            i.remove();
            this.notifyMessageRemoved(m);
            return m;
        }
        return null;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public List getMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    public void pushMessageOntoStack(Message msg) {
        if (msg.getType().equals("queue_post_message")) {
            String serialized = msg.getBody();
            Logger.log("Add message to queue " + this.queueId);
            Logger.log("Message is:\n" + serialized);
            try {
                Message data = MessageFactory.decodeMessage(serialized);
                Logger.log("Deserialized OK");
                this.addMessage(data);
            }
            catch (IOException ioe) {
                Logger.log(ioe);
            }
            return;
        }
        if (msg.getType().equals("queue_delete_message")) {
            String msgid = msg.getBody();
            Logger.log("Remove message from  queue " + this.queueId);
            Logger.log("Message is " + msgid);
            this.removeMessage(msgid);
            return;
        }
        if (msg.getType().equals("queue_unlock")) {
            String lockid = msg.getBody();
            Logger.log("Remove lock " + lockid + "+ from  queue " + this.queueId);
            this.removeLock(lockid);
            return;
        }
        this.stack.pushMessage(msg);
    }

    public void popMessageFromStack(Message msg) {
        this.stack.removeMessage(msg);
    }

    public synchronized void addMessage(Message msg) {
        this.messages.add(msg);
        this.notifyMessageAdded(msg);
    }

    protected synchronized void removeLock(String lockid) {
        Node owner = this.stack.removeLockID(lockid);
        if (owner == null) {
            return;
        }
        if (owner == Node.getLocalNode()) {
            this.locked = false;
        }
        this.owners.remove(owner);
    }

    public synchronized void removeMessage(String id) {
        Iterator i = this.messages.iterator();
        while (i.hasNext()) {
            Message m = (Message)i.next();
            if (!m.getId().equals(id)) continue;
            i.remove();
            this.notifyMessageRemoved(m);
            break;
        }
    }

    public CoordinationMessagesStack getStack() {
        return this.stack;
    }

    public synchronized boolean checkAndAcquireLock(String lockid) {
        if (this.locked) {
            return false;
        }
        if (this.stack.checkAndAcquireLock(lockid, this.owners)) {
            this.locked = true;
            return true;
        }
        return false;
    }

    public synchronized void addOwner(Node owner) {
        this.owners.add(owner);
    }

    public synchronized void removeOwner(Node owner) {
        this.owners.remove(owner);
    }

    public synchronized List findAgreeableLockMessages() {
        return this.stack.findAgreeableLockMessages(this.owners);
    }

    public synchronized Node getMostImportantOwner() {
        Node best = null;
        int prio = -1;
        Iterator i = this.owners.iterator();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            int np = n.getPriority();
            if (np <= prio) continue;
            prio = np;
            best = n;
        }
        return best;
    }

    public synchronized void notifyNodeRemoved(Node n) {
        this.stack.removeAllMessagesByNode(n);
        if (this.owners.contains(n)) {
            this.owners.remove(n);
        }
    }
}

