/*
 * Decompiled with CFR 0.152.
 */
package qms.messages;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import qms.messages.MessageListener;
import qms.util.DOMUtils;
import qms.util.Logger;

public class Message {
    public static final String NAME_SPACE = "qms";
    protected String id;
    protected String body;
    protected String sender;
    protected String recipient;
    protected String queueId;
    protected String type;
    protected long creation_time_stamp;
    protected Document doc;
    protected Map attributes;
    protected transient MessageListener listener = null;

    public Message() {
        this.creation_time_stamp = System.currentTimeMillis();
        this.id = "msid" + this.creation_time_stamp;
        this.attributes = new HashMap();
        this.type = "unset";
        this.recipient = "unset";
        this.sender = "unset";
        this.queueId = "unset";
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.doc = null;
        this.type = type;
    }

    public String getAttribute(String name) {
        return (String)this.attributes.get(name);
    }

    public void setAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    protected void parseDocument() {
        Element root = this.doc.getDocumentElement();
        this.sender = root.getAttribute("sender");
        this.recipient = root.getAttribute("recipient");
        this.queueId = root.getAttribute("queueId");
        this.id = root.getAttribute("id");
        this.type = root.getAttribute("type");
        this.body = root.getAttribute("body");
        NamedNodeMap attributes = root.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr at = (Attr)attributes.item(i);
            String name = at.getName();
            String value = at.getValue();
            this.setAttribute(name, value);
        }
    }

    public void notifyListener(boolean result) {
        if (this.listener != null) {
            this.listener.notifyMessageDelivered(this, result);
        }
    }

    public void setListener(MessageListener listener) {
        this.listener = listener;
    }

    protected void createDocument() throws DOMException {
        this.doc = DOMUtils.newDocument();
        Element message = this.doc.createElement("message");
        this.doc.appendChild(message);
        message.setAttribute("sender", this.sender);
        message.setAttribute("recipient", this.recipient);
        message.setAttribute("id", this.id);
        message.setAttribute("type", this.type);
        message.setAttribute("queueId", this.queueId);
        message.setAttribute("body", this.body);
        Iterator i = this.attributes.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            String value = (String)this.attributes.get(name);
            message.setAttribute(name, value);
        }
    }

    public String getId() {
        return this.id;
    }

    public Message(String from, String to, String queueid, String type, String body) {
        this();
        this.sender = from;
        this.recipient = to;
        this.body = body;
        this.type = type;
        this.queueId = queueid;
        this.attributes = new HashMap();
        this.createDocument();
    }

    public Message(Document doc) throws DOMException {
        this();
        this.setDocument(doc);
    }

    public String toString() {
        return this.id + " " + this.type + " From " + this.sender + " To " + this.recipient + " " + this.body;
    }

    public String asXML() {
        try {
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            this.serialize(bao);
            return new String(bao.toByteArray());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new IllegalStateException("Can't rapresent message as XML:" + e);
        }
    }

    public Document getDocument() throws DOMException {
        return this.doc;
    }

    public void serialize(OutputStream os) throws IOException {
        this.update();
        DOMUtils.serialize(this.doc, os);
    }

    public void setDocument(Document doc) throws DOMException {
        try {
            this.doc = doc;
            this.parseDocument();
        }
        catch (Exception e) {
            Logger.log(e);
            throw new DOMException(4, "Impossibile interpretare il messaggio XML:" + e);
        }
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.doc = null;
        this.body = body;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.doc = null;
        this.sender = sender;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String recipient) {
        this.doc = null;
        this.recipient = recipient;
    }

    public long getCreationTimeStamp() {
        return this.creation_time_stamp;
    }

    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    protected Message(Message other) {
        this.sender = other.sender;
        this.recipient = other.recipient;
        this.body = other.body;
        this.creation_time_stamp = other.creation_time_stamp;
        this.queueId = other.queueId;
        this.id = other.id;
        this.type = other.type;
        this.doc = DOMUtils.newDocument();
        this.attributes = new HashMap(other.attributes);
        this.doc = other.doc;
        this.listener = other.listener;
    }

    public Message copy() {
        return new Message(this);
    }

    public void update() {
        try {
            this.createDocument();
        }
        catch (DOMException de) {
            Logger.log(de);
            throw new IllegalStateException("Unable to update message:" + de);
        }
    }
}

