/*
 * Decompiled with CFR 0.152.
 */
package qms.group;

import java.net.URL;
import qms.io.NodeAccessPoint;

public class Node
implements Comparable {
    protected static Node local_node;
    protected static NodeAccessPoint local_access_point;
    protected URL access_point = null;
    protected int priority = -1;
    protected String name = "unnamed" + System.currentTimeMillis();
    protected int fault_count = 0;

    public static Node getLocalNode() {
        return local_node;
    }

    public static void setLocalAccessPoint(NodeAccessPoint nap) {
        local_access_point = nap;
    }

    public static NodeAccessPoint getLocalAccessPoint() {
        return local_access_point;
    }

    public int getFaultCount() {
        return this.fault_count;
    }

    public void incFaultCount() {
        ++this.fault_count;
    }

    public void setPriority(int p) {
        this.priority = p;
    }

    public int getPriority() {
        return this.priority;
    }

    public URL getAccessPoint() {
        return this.access_point;
    }

    public void setAccessPoint(URL ap) {
        this.access_point = ap;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void calculatePriority() {
        int p = 0;
        for (int i = 0; i < this.name.length(); ++i) {
            p += this.name.charAt(i);
        }
        this.setPriority(p);
    }

    public void setName(String name) {
        this.name = name;
        this.calculatePriority();
    }

    public boolean equals(Object o) {
        Node on = (Node)o;
        return on.name.equals(this.name);
    }

    public int compareTo(Object obj) {
        Node o = (Node)obj;
        if (this.name.equals(o.name)) {
            return 0;
        }
        return o.priority - this.priority;
    }

    static {
        try {
            local_node = new Node();
            local_node.setName("qms");
            local_node.setAccessPoint(new URL("http://localhost/qms"));
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't initialize current node ids");
        }
        local_access_point = null;
    }
}

