/*
 * Decompiled with CFR 0.152.
 */
package qms.group;

import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import qms.group.Group;
import qms.group.Node;
import qms.io.Messenger;
import qms.messages.Message;

public class Multicaster
implements Runnable {
    protected Group group;
    protected Thread sender_thread;
    protected LinkedList message_queue;
    protected Messenger messenger;
    public static String ALL = "all_nodes";

    public List getUnsentMessages() {
        return new Vector(this.message_queue);
    }

    public Multicaster(Group group) {
        this.group = group;
        this.message_queue = new LinkedList();
        this.sender_thread = null;
        this.messenger = new Messenger();
    }

    public void castMessage(Message msg) {
        if (msg.getRecipient().equals(ALL)) {
            Iterator i = this.group.iterator();
            while (i.hasNext()) {
                Node n = (Node)i.next();
                Message copy = msg.copy();
                copy.setRecipient(n.getName());
                copy.update();
                this.enqueueMessage(copy);
            }
        } else {
            this.enqueueMessage(msg);
        }
    }

    public boolean castMessage(Message m, Node node) {
        return this.messenger.sendMessage(m, node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void enqueueMessage(Message m) {
        LinkedList linkedList = this.message_queue;
        synchronized (linkedList) {
            this.message_queue.addLast(m);
            if (this.sender_thread == null && this.message_queue.size() == 1) {
                this.startSenderThread();
            }
        }
    }

    protected void startSenderThread() {
        if (this.sender_thread != null) {
            throw new IllegalStateException("Can't start two times sender thread for a multicaster");
        }
        this.sender_thread = new Thread(this);
        this.sender_thread.setDaemon(true);
        this.sender_thread.start();
    }

    protected void sendMessage(Message m) {
        Node node = this.group.lookupNode(m.getRecipient());
        if (node == null) {
            System.out.println("Can't find node " + m.getRecipient());
            m.notifyListener(false);
            return;
        }
        if (node.equals(Node.getLocalNode())) {
            Node.getLocalAccessPoint().messageReceived(m);
        } else {
            URL access_point = node.getAccessPoint();
            this.messenger.sendMessage(m, node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            LinkedList linkedList = this.message_queue;
            synchronized (linkedList) {
                if (this.message_queue.size() == 0) {
                    this.sender_thread = null;
                    return;
                }
                Message msg = (Message)this.message_queue.removeFirst();
                this.sendMessage(msg);
            }
        }
    }
}

