/*
 * Decompiled with CFR 0.152.
 */
package qms.group;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import qms.group.Group;
import qms.group.Node;
import qms.messages.Message;
import qms.util.Logger;

public class CoordinationMessagesStack
implements Comparator {
    protected List stack;
    protected Group nodes;

    public CoordinationMessagesStack(Group group_knowledge) {
        this.nodes = group_knowledge;
        this.stack = new LinkedList();
    }

    public synchronized void pushMessage(Message m) {
        this.stack.add(m);
        Collections.sort(this.stack, this);
    }

    public synchronized void removeMessage(Message cm) {
        this.stack.remove(cm);
    }

    public synchronized Message[] getSnapshot() {
        Message[] result = new Message[this.stack.size()];
        for (int i = 0; i < this.stack.size(); ++i) {
            result[i] = (Message)this.stack.get(i);
        }
        return result;
    }

    public synchronized boolean checkAndAcquireLock(String lockid, Set owners) {
        Node local = Node.getLocalNode();
        int local_prio = local.getPriority();
        Iterator i = owners.iterator();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            if (local_prio >= n.getPriority()) continue;
            return false;
        }
        Vector<Message> agreements = new Vector<Message>();
        Iterator i2 = this.stack.iterator();
        while (i2.hasNext()) {
            Message m = (Message)i2.next();
            if (m.getType().equals("queue_agree_lock") && m.getBody().equals(lockid)) {
                agreements.add(m);
            }
            if (agreements.size() < this.nodes.size()) continue;
            this.stack.removeAll(agreements);
            return true;
        }
        return false;
    }

    public synchronized List findAgreeableLockMessages(Set owners) {
        Vector<Message> result = new Vector<Message>();
        int min_prio = -1;
        Iterator i = this.stack.iterator();
        while (i.hasNext()) {
            Message m = (Message)i.next();
            if (!m.getType().equals("queue_request_lock")) continue;
            Node competitor = this.nodes.lookupNode(m.getSender());
            if (competitor == null) {
                throw new AssertionError((Object)("Unknown node " + m.getSender()));
            }
            if (competitor.getPriority() <= min_prio) continue;
            min_prio = competitor.getPriority();
            boolean ok = true;
            Iterator o = owners.iterator();
            while (ok && o.hasNext()) {
                Node n = (Node)o.next();
                if (n.getPriority() < competitor.getPriority()) continue;
                ok = false;
            }
            if (!ok) continue;
            result.add(m);
            m.setType("queue_lock_agreed");
        }
        return result;
    }

    public synchronized Node removeLockID(String lockid) {
        Iterator i = this.stack.iterator();
        while (i.hasNext()) {
            Message m = (Message)i.next();
            if (!m.getType().equals("queue_lock_agreed") || !m.getBody().equals(lockid)) continue;
            Node n = this.nodes.lookupNode(m.getSender());
            i.remove();
            return n;
        }
        Logger.log("Attenzione!!! Qualcuno mi ha chiesto di rimuovere li lockid " + lockid + " che non \u00e8 mai stato accettato!!!");
        return null;
    }

    public int compare(Object o, Object o2) {
        Node n2;
        Message m1 = (Message)o;
        Message m2 = (Message)o2;
        Node n1 = this.nodes.lookupNode(m1.getSender());
        int prio = n1.compareTo(n2 = this.nodes.lookupNode(m2.getSender()));
        if (prio == 0) {
            return (int)(m1.getCreationTimeStamp() - m2.getCreationTimeStamp());
        }
        return prio;
    }

    public Iterator iterator() {
        return this.stack.iterator();
    }

    public synchronized void removeAllMessagesByNode(Node n) {
        Iterator m = this.stack.iterator();
        while (m.hasNext()) {
            Message msg = (Message)m.next();
            if (!msg.getSender().equals(n.getName()) && !msg.getRecipient().equals(n.getName())) continue;
            m.remove();
        }
    }
}

