/*
 * Decompiled with CFR 0.152.
 */
package qms.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import qms.client.QMSException;
import qms.messages.Message;
import qms.messages.MessageFactory;

public class QMSClient {
    protected URL access_point = null;
    protected String user = "anonymous";

    public void setUser(String user) {
        this.user = user;
    }

    public void setAccessPoint(URL access_point) {
        this.access_point = access_point;
    }

    /*
     * Loose catch block
     */
    protected Message sendMessage(Message m) throws QMSException {
        IOException io22;
        Message message;
        InputStream in;
        OutputStream os;
        block13: {
            Message response;
            if (this.access_point == null) {
                throw new QMSException("Access point not set");
            }
            m.update();
            URLConnection con = null;
            os = null;
            in = null;
            con = this.access_point.openConnection();
            con.setDoOutput(true);
            os = con.getOutputStream();
            m.serialize(os);
            in = con.getInputStream();
            message = response = MessageFactory.decodeMessage(in);
            Object var8_8 = null;
            if (os == null) break block13;
            try {
                os.close();
            }
            catch (IOException io22) {
                // empty catch block
            }
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException io22) {
                // empty catch block
            }
        }
        return message;
        catch (IOException io3) {
            try {
                io3.printStackTrace();
                throw new QMSException("IOError while talking with SAP " + this.access_point, io3);
            }
            catch (Throwable throwable) {
                block15: {
                    IOException io22;
                    Object var8_9 = null;
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException io22) {
                            // empty catch block
                        }
                    }
                    if (in == null) break block15;
                    try {
                        in.close();
                    }
                    catch (IOException io22) {}
                }
                throw throwable;
            }
        }
    }

    public void postMessage(String recipient, String queue_name, String body) throws QMSException {
        Message msg = new Message(this.user, recipient, queue_name, "user_post_message", body);
        this.sendMessage(msg);
    }

    public void deleteMessage(String queue_name, String msgid) throws QMSException {
        Message msg = new Message(this.user, "system", queue_name, "user_delete_message", msgid);
        this.sendMessage(msg);
    }

    public List listMessages(String queue_name) throws QMSException {
        Vector<String> result = new Vector<String>();
        Message msg = new Message(this.user, "system", queue_name, "user_list_messages", "");
        Message response = this.sendMessage(msg);
        String body = response.getBody();
        StringTokenizer tok = new StringTokenizer(body, "\n");
        while (tok.hasMoreTokens()) {
            result.add(tok.nextToken());
        }
        return result;
    }

    public void deleteQueue(String queue_name) throws QMSException {
        Message msg = new Message(this.user, "any", queue_name, "user_delete_queue", "");
        Message response = this.sendMessage(msg);
        System.out.println(response.asXML());
    }

    public Message getMessage(String queue_name, String msgid) throws QMSException {
        Message msg = new Message(this.user, "any", queue_name, "user_get_message", msgid);
        return this.sendMessage(msg);
    }
}

