/*
 * MonitorServer.java
 *
 * 
 */
 package	DisCSP.DistributedCSP;

import java.io.*;
import java.net.*;

/**
 * @ version 1.0
 *
 * @ author Nocerino Francesca
 *
 * @ since JDK 1.4
 *
 */


public class MonitorServer  extends Thread
{
	private int PORT;
	private AgentDescriptor[] agents;
	private MonitorState state;
	private PrintStream prtStr;
 	/** Costruttore di MonitorServer
     * 
     * @param p la porta del monitor
     * @param ag i descrittori degli agenti
     * @param s lo stato del Monitor
     * @param ps il PrintStream su cui direzionare l'output
     * 
     */	

	public MonitorServer(int p,AgentDescriptor[] ag,MonitorState s, PrintStream ps)
	{
		prtStr=ps;
		PORT=p;
		agents=ag;
		state=s;
	}
	
	/** Metodo run del Thread
     * 
     * 
     */	

	public  void run()
	{
		try
		{
			ServerSocket serverSocket =	new	ServerSocket(PORT);
			prtStr.println("Monitor started");
			while(!state.consistent())
			{
				// bloccante finch	non	avviene	una	connessione:
				
				Socket clientSocket	= serverSocket.accept();
				try
				{
					new MonitorServerThread(clientSocket,agents,state,prtStr);
				}
				catch(IOException e)
				{
					clientSocket.close();
		  		}
	  		}
	  		
	  		serverSocket.close();
	  		
		}
		catch (Exception e)
		{
			prtStr.println("Monitor can't accept any connection.");
		}
		
	

	}

} 

