/*
 * ExtGreaterEqualConstraint.java
 *
 * 
 */
 package DisCSP.DistributedCSP.ExternalConstraint;

import DisCSP.CSP.*;
import DisCSP.Exception.*;
import DisCSP.CSPLexerParser.*;

/**
 * @ version 1.0
 *
 * @ author Nocerino Francesca
 *
 * @ since JDK 1.4
 *
 */


public class ExtGreaterEqualConstraint implements ExtBinaryConstraint
{
	private Variable local;
	private String external;
	
	/** Costruttore di ExtGreaterEqualConstraint
	 * 
	 * @param lv la variabile locale coinvolta nel vincolo
	 * @param v2 il nome della variabile esterna coinvolta nel vincolo
	 * 
	 */		
	public ExtGreaterEqualConstraint(Variable lv, String ev) throws NotBinaryConstrException
	{
		if(lv.getName().equals(ev)) throw new NotBinaryConstrException(lv.getName());
		local=lv;
		external=ev;
	}
	
 	/** Verifica, dati due interi v1 e v2, se v1==v2 
     * 
	 * @param v1 il primo intero
	 * @param v2 il secondo intero
     * @return true se v1==v2, false altrimenti
     * 
     */		
	public boolean check(int v1, int v2)
	{
		return v1>=v2;
	}

	
/*	public ExtBinaryConstraint getCopy()
	{
		return new ExtGreaterEqualConstraint( local.getCopy(), new String(external));
	}
*/	

 	/** Restituisce la variabile locale coinvolta nel vincolo
     * 
     * @return la variabile locale
     * 
     */	
	public Variable getLocalVariable()
	{
		return local;
	}
	
 	/** Restituisce il nome della variabile esterna coinvolta nel vincolo
     * 
     * @return la variabile esterna coinvolta nel vincolo
     * 
     */	
	public String getExternalVariable()
	{
		return external;
	}


	 /** Stampa il vincolo
     * 
     * @return una stringa rappresentante il vincolo
     * 
     */			
	public String print()
	{
		return local.getName()+">="+ external;
	}

}