/*
 * AgentDescriptor.java
 *
 * 
 */
 package DisCSP.DistributedCSP;

import java.util.Vector;
import java.net.*;

/**
 * @ version 1.0
 *
 * @ author Nocerino Francesca
 *
 * @ since JDK 1.4
 *
 */


class AgentDescriptor
{
	private InetAddress address;
	private int port;
	private int currentInitiative=-1;
	private String[] state;

 	/** Costruttore di AgentDescriptor
     * 
     * @param addr l'IP dell'agente
     * @param p la porta dell'agente
     * @param numAgents il numeromdegli agenti
     * 
     */	
     
	public AgentDescriptor(String addr, int p,int numAgents)
	{
		
		try
		{	
			address=InetAddress.getByName(addr);
		}
		catch(UnknownHostException he)
		{
			
		}
		port=p;
		state=new String[numAgents-1];
		for(int i=0;i<state.length;i++)
		{
			state[i]="";
		}
	}
	
	
	/** Restituisce l'indirizzo IP dell'agente
     * 
     * @return l'indirizzo IP dell'agente
     * 
     */			
	public InetAddress address() throws UnknownHostException
	{
		return 	address;
	}
	
	/** Restituisce l'indirizzo IP dell'agente come stringa
     * 
     * @return una stringa rappresentante l'indirizzo IP dell'agente
     * 
     */			
	public String addressString()
	{
		return address.getHostAddress();
	}
	
	/** Restituisce la porta dell'agente
     * 
     * @return l'intero corrispondente alla porta dell'agente
     * 
     */			
	public int port()
	{
		return port;
	}
	
	/** Memorizza l'iniziativa corrente di rilevazione dell'arc-consistenza
     * 
     * @param init il numero di iniziativa
     * 
     */		
	public void setCurrentInitiative(int init)
	{
		if(init>currentInitiative)
		{
			for(int i=0;i<state.length;i++)
			{
				state[i]="";
			}
			currentInitiative=init;
		}		
		
		
	}
	
	/** Restituisce l'iniziativa corrente di rilevazione dell'arc-consistenza
     * 
     * @return il numero di iniziativa
     * 
     */				
	
	public int currentInitiative()
	{
		return currentInitiative;
	}
	
	/** Permette di memorizzare lo stato di un agente
     * 
     * @param init il numero di iniziativa
     * @param st lo stato dell'agente
     * 
     */				
	
	public void setState(int init, String st)
	{
		if(init<currentInitiative) return;
		if(init==currentInitiative)
		{
			for(int i=0;i<state.length;i++)
			{
				if(state[i]=="")
				{
					state[i]=st;
					return;	
				}
			}
		}
		if(init>currentInitiative)
		{
			state[0]=st;
			for(int i=1;i<state.length;i++)
			{
				state[i]="";
			}
			currentInitiative=init;
		}		
		
	}
	
	/** Verifica se tutti gli agenti sono in stato di waiting
     * 
     * @return true se tutti gli agenti sono in stato di waiting, false altrimenti
     * 
     */				
	
	public boolean test()
	{
		for(int i=0;i<state.length;i++)
		{
			if(!state[i].equals("arc_waiting") ) return false;
		}
		
		return true;
	}
	
}
