/*
 * Token.java
 *
 * 
 */


package DisCSP.CSPLexerParser;

import DisCSP.Exception.*;

import java.io.*;

/**
 * @ version 1.0
 *
 * @ author Nocerino Francesca
 *
 * @ since JDK 1.4
 *
 */
 

public class Token
{
	boolean isInt = false;
	boolean	isEnd = false;
	boolean	isEol = false;
	boolean	isCh= false;
	boolean isStr=false;
	int intValue;
	char charValue;
	String strValue;
	
	 
 	/** Costruttore di Token
     * 
     * @param t indica il tipo di token letto dallo StreamTokenizer
     * @param nval il numero eventualmente letto dallo StreamTokenizer
     * @param ttype il carattere eventualmente letto dallo StreamTokenizer
     * @param sval la stringa eventualmente letta dallo StreamTokenizer
     * 
     */

	public Token(int t, double nval, int ttype,String sval)
	{
		if(t==StreamTokenizer.TT_NUMBER)
		{
			isInt=true;
			intValue = (int) nval;	
		}
		else if(t==StreamTokenizer.TT_WORD)
		{	
			isStr = true;
			strValue=sval;
		
		}
		else if(t==StreamTokenizer.TT_EOF)
		{	
			isEnd = true;
			//throw new StreamEOFException();
		}
		else if(t==StreamTokenizer.TT_EOL)
		{	
			isEol = true;
		}		
	
		else
		{
			isCh = true;
			charValue=(char) ttype;
		}
	}
	
	/**Getter di isDb
     * 
     * @return true se il token corrente  un double
     * 
     */
	public boolean isInt()
	{
		return isInt;
	}
	
	public boolean isEnd()
	{
		return isEnd;
	}
	
	public boolean isEOL()
	{
		return isEol;
	}

	/**Getter di isCh
     * 
     * @return true se il token corrente  un carattere
     * 
     */
	public boolean isChar()
	{
		return isCh;
	}
	
	/**Getter di isStr
     * 
     * @return true se il token corrente  unaStringa
     * 
     */
	public boolean isString()
	{
		return isStr;
	}
	
	/**Getter di doubleValue
     * 
     * @return se il token corrente  un double lo restituisce
     * 
     */
	public int getInt() throws LexerException
	{
		if(isInt)
			return intValue;
	  	else 
	  		throw new LexerException("int not found");
	}

	/**Getter di charValue
     * 
     * @return se il token corrente  un char lo restituisce
     * 
     */
	public char getChar()  throws LexerException
	{
		if(isCh)
			return charValue;
	  	else 
	  		throw new LexerException("char not found");
	}
	
	/**Getter di strValue
     * 
     * @return se il token corrente  una stringa la restituisce
     * 
     */
	public String getString()  throws LexerException
	{
		if(isStr)
			return strValue;
	  	else 
	  		throw new LexerException("string not found");
		
	}
}