/*
 * Lexer.java
 *
 * 
 */

package DisCSP.CSPLexerParser;

import DisCSP.Exception.*;

import java.io.*;

/**
 * @ version 1.0
 *
 * @ author Nocerino Francesca
 *
 * @ since JDK 1.4
 *
 */
 
public class Lexer extends StreamTokenizer
{

	
 
 	/** Costruttore di Lexer
     * 
     * @param input la stringa da cui il lexer ottiene i token
     * 
     */
     
	public Lexer(String input)
	{
		super(new StringReader(input.replace('.',Symbols.PUNTO).replaceAll(">=","!>").replaceAll("<=","!<") ) );
		
	}	
	
	/**Restituisce il prossimo token
     * 
     * @return Token trovato nella posizione succesiva a quella corrente
     * 
     */
     
	protected Token getNextToken() throws LexerException
	{
		try
		{
			int t=nextToken();
			return 	new Token(t,nval,ttype,sval);
		}
		catch(IOException e)
		{
			throw new LexerException("nextToken");	
		}
	}
	
	/**Restituisce il prossimo token
     * 
     * @return double trovato nella posizione succesiva a quella corrente
     * 
     */
	public int getInt() throws LexerException
	{
		int d;
		Token token=getNextToken();
		if(token.isInt())
			return d =token.getInt();
		else throw new LexerException("int not found");	
	}
	
	/**Restituisce il prossimo token
     * 
     * @return char trovato nella posizione succesiva a quella corrente
     * 
     */
     
	public char getChar() throws LexerException
	{
		char c;
		Token token=getNextToken();
		if(token.isChar())
			c =token.getChar();	
		else throw new LexerException("char not found");
		if(c==Symbols.APERTA_QUADRA||c==Symbols.CHIUSA_QUADRA||c==Symbols.UGUALE||c==Symbols.DUE_PUNTI||c==Symbols.PUNTO||c==Symbols.VIRGOLA||c==Symbols.SPECIAL||c==Symbols.MAGGIORE||c==Symbols.MINORE)
			return c;
		else throw new LexerException("valid char not found");
	}
	
	/**Restituisce il prossimo token
     * 
     * @return String trovata nella posizione succesiva a quella corrente
     * 
     */
     
	public String getString() throws LexerException
	{
		String s;
		Token token=getNextToken();
		if(token.isString())
			return s =token.getString();
		else throw new LexerException("string not found");
		
	}
}
