/*
 * MonitorSetupJFrame.java
 *
 * 
 */
 package DisCSP.CSPApplication;

import javax.swing.*;
import javax.swing.event.*;
import DisCSP.DistributedCSP.*;
import java.awt.event.*;
import java.awt.*;
import java.util.Vector;
import java.io.*;
import java.net.*;

/**
 * @ version 1.0
 *
 * @ author Nocerino Francesca
 *
 * @ since JDK 1.4
 *
 */

public class MonitorSetupJFrame extends JFrame
{
	
	JTextField agentIP;
	JTextField agentPort;
	DefaultListModel listModel;	
	JList agentList;
	JLabel IP;
	JTextField port;
	JButton startButton;
	Vector global=new Vector();
	Monitor monitor;
	JTextArea output;
	ByteArrayOutputStream byteStr= new ByteArrayOutputStream();
	PrintStream	prtStr=new PrintStream(byteStr);
	
 	/** Costruttore di MonitorSetupJFrame
     * 
     * 
     */	
    public MonitorSetupJFrame()
    {
		            
        setResizable(false);


        setTitle("Monitor");
        setSize(new Dimension(400, 500));


 		Box agentIPBox= new Box(BoxLayout.X_AXIS );
        JLabel agentIPLabel= new JLabel("IP:   ");
        agentIP=new JTextField("",10);
		agentIPBox.add(agentIPLabel);
		agentIPBox.add(agentIP);
 		Box agentPortBox= new Box(BoxLayout.X_AXIS );
		JLabel agentPortLabel= new JLabel("Port: ");
        agentPort=new JTextField("",5);
        agentPortBox.add(agentPortLabel);
        agentPortBox.add(agentPort);         
 		Box agentButtonBox= new Box(BoxLayout.X_AXIS );
		JButton agentAddButton= new JButton("Add");
		JButton agentRemoveButton= new JButton("Remove");
        agentButtonBox.add(agentAddButton);         
        agentButtonBox.add(agentRemoveButton);         
				
		Box agentAddBox= new Box(BoxLayout.Y_AXIS );
 		agentAddBox.add(agentIPBox);
		agentAddBox.add(agentPortBox);
 		agentAddBox.add(new JLabel(" "));
		agentAddBox.add(agentButtonBox);
		
		listModel=new  DefaultListModel(); 
		agentList= new JList(listModel);
		agentList.setVisibleRowCount(5);
		agentList.setFixedCellWidth(150);
		agentList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION );
		JScrollPane scrollAgentList = new JScrollPane(agentList);
		scrollAgentList.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED );
		scrollAgentList.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS );
		
		for(int i=0;i<global.size();i++)
		{
			listModel.addElement((String)global.elementAt(i));
		}
		

		Box agentBox= new Box(BoxLayout.X_AXIS );
 		agentBox.add(agentAddBox);
 		agentBox.add(Box.createHorizontalStrut(75));
 		agentBox.add(scrollAgentList);
		
		startButton= new JButton("Start Monitor");
		
		Box IPBox= new Box(BoxLayout.X_AXIS );
        JLabel IPLabel= new JLabel("IP:   ");
		String ip="";
		try
		{
			ip=(InetAddress.getLocalHost()).getHostAddress();
		}
		catch(UnknownHostException he)
		{
			
		}      
        IP=new JLabel(ip,10);
		IPBox.add(IPLabel);
		IPBox.add(IP);
 		Box portBox= new Box(BoxLayout.X_AXIS );
		JLabel portLabel= new JLabel("Port: ");
        port=new JTextField("",5);
        portBox.add(portLabel);
        portBox.add(port); 
       	Box addressBox= new Box(BoxLayout.Y_AXIS );
 		addressBox.add(IPBox);
 		addressBox.add(new JLabel(" "));
		addressBox.add(portBox);
		addressBox.add(new JLabel(" "));
		addressBox.add(startButton);
        
        Box outputBox=new Box(BoxLayout.Y_AXIS);
		output= new JTextArea(9,33);
		output.setEditable(false);
	   	JScrollPane scrollOuput = new JScrollPane(output);
		outputBox.add(new JLabel(" "));
		outputBox.add(scrollOuput);
		scrollOuput.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS );
		scrollOuput.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED );


		startButton.addActionListener
		(
			new ActionListener()
 			{
 				public void actionPerformed (ActionEvent e)
 				{
			    	startButton.setEnabled(false);
			    	int portInt=new Integer(port.getText()).intValue();
			    	int totAgent=global.size();
			    	String [] globalIP= new String[totAgent];
			    	int [] globalPort= new int[totAgent];
			    	for(int i=0;i<totAgent;i++)
			    	{
			    		String[] app= ((String) global.elementAt(i)).split(" ");
			    		globalIP[i]=app[0];
			    		globalPort[i]=new Integer(app[1]).intValue();
			    		
			    	}
			    	monitor=new Monitor(IP.getText(),portInt,globalIP,globalPort,prtStr);
					try
					{
						monitor.join();
					}
					catch(InterruptedException ie)
					{
					}
					output.setText(byteStr.toString());
			    	startButton.setEnabled(true);
 				}
 			}
		);
		
		agentAddButton.addActionListener
		(
			new ActionListener()
 			{
 				public void actionPerformed (ActionEvent e)
 				{

					MonitorSetupJFrame.this.addAgent();
 				}
 			}
		);		

		agentRemoveButton.addActionListener
		(
			new ActionListener()
 			{
 				public void actionPerformed (ActionEvent e)
 				{
					MonitorSetupJFrame.this.removeAgent();
 				}
 			}
		);
		
 		JPanel agentPanel = new JPanel();
 		agentPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(),"Monitor Setup"));
 		agentPanel.add(agentBox);
  		JPanel addressPanel = new JPanel();
 		addressPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(),"Monitor Location"));
 		addressPanel.add(addressBox);
  		JPanel outputPanel = new JPanel();
 		outputPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(),"Output"));
 		outputPanel.add(outputBox);
		
 		Box tot= new  Box(BoxLayout.Y_AXIS);
		tot.add(agentPanel);
		tot.add(addressPanel);
		tot.add(outputPanel);
		
		this.getContentPane().add(tot);
 	
        this.validate();
    }	
	
	private void addAgent()
	{		
		try
		{
			String app=agentIP.getText()+" "+agentPort.getText();
			if(!global.contains(app))
			{
				global.addElement(app);
				listModel.addElement(app); 		
			}
		}
		catch(Exception e)
		{
		}

		
	}

	private void removeAgent()
	{		
		int sel= agentList.getSelectedIndex();
		
		if(sel!=-1)
		{
			String varLine=(String) agentList.getSelectedValue();
			listModel.removeElementAt(sel); 	
			global.removeElement(varLine);
		}
	}
	
	
	

}
