/*
 * VariableVector.java
 *
 * 
 */
 package DisCSP.CSP;

/**
 * @ version 1.0
 *
 * @ author Nocerino Francesca
 *
 * @ since JDK 1.4
 *
 */


import java.util.Vector;

class VariableVector extends Vector
{

 	/** Costruttore di VariableVector
     * 
     * 
     */
     public VariableVector()
	{
		super();
	}

 	/** Costruttore di VariableVector
     * 
     * @param var una variabile del vettore
     * 
     */	
	public VariableVector (Variable var)
	{
		super();
		add(var);
	}

	 /** Restituisce l'i-esima variabile
     * 
	 * @param i l'indice
     * @return l'i-esima variabile
     * 
     */		
	public Variable variableAt(int i)
	{
		return (Variable) elementAt(i);
	}
	
	 /**  Aggiunge una variabile
     * 
	 * @param v la  variabile
     * 
     */			
	public void addVariable(Variable var)
	{
		add(var);
	}

	 /**  Elimina una variabile
     * 
	 * @param v la  variabile
     * 
     */					
	public void removeVariable(Variable var)
	{
		remove(var);
	}
	
	 /**  Controlla se una variabile  presente
     * 
	 * @param v la  variabile
     * @return true se v  presente, false altrimenti
     * 
     */	
	public boolean isPresent(Variable v)
	{
		if(isEmpty())
			return false;
		for(int i=0;i<size();i++)
		{
			if(variableAt(i).getName().equals(v.getName()) )
				return true;
		}
		return false; 
	}


}