/*
 * Variable.java
 *
 * 
 */
 package DisCSP.CSP;

/**
 * @ version 1.0
 *
 * @ author Nocerino Francesca
 *
 * @ since JDK 1.4
 *
 */


public class Variable
{
	private String name;
	private Domain dom;

 	/** Costruttore di Variable
     * 
     * @param n il nome della variabile
     * @param d il dominio della variabile
     * 
     */	
	public Variable(String n, Domain d)
	{
		name=n;
		dom=d;
	}
	
/*	public Variable getCopy()
	{
		 return new Variable(new String(name), new Domain(dom));
	}
*/	
	 /** Restituisce il dominio della variabile
     * 
     * @return il dominio della variabile
     * 
     */		
	public  Domain getDomain()
	{
		return dom;
	}
	 
	 /** Restituisce il nome della variabile
     * 
     * @return il nome della variabile
     * 
     */			
	public String getName()
	{
		return name;
	}
	
	/** Stampa il nome della variabile e il suo dominio
	 *
     * @return il nome della variabile e il suo dominio
     * 
     */		
	public  String print()
	{
		return name+"::"+dom.print();
	}
	
	/** Stampa il dominio della variabile
	 *
     * @return il dominio della variabile
     * 
     */			
	public  String printDomain()
	{
		return dom.print();
	}

	 /** Permette di definire il dominio della variabile
     * 
	 * @param d il dominio
     * 
     */			
	public void setDomain(Domain d)
	{
		dom=d;
	}


}