/*
 * PropagationAlgorithm.java
 *
 * 
 */
 package DisCSP.CSP;

/**
 * @ version 1.0
 *
 * @ author Nocerino Francesca
 *
 * @ since JDK 1.4
 *
 */


import DisCSP.CSP.Constraint.*;
import DisCSP.Exception.*;
import java.util.Vector;
public class PropagationAlgorithm
{

 	/** Costruttore di PropagationAlgorithm
     * 
     * 
     */
     public PropagationAlgorithm()
	{
	}

	 /** Rende un CP arc-consistente
     * 
	 * @param constrProbl il problema
     * @return i nomi delle variabili i cui domini sono stati modificati
     * 
     */		
	public String[] arc_consistency(ConstraintProblem constrProbl) throws NoSolutionException, ExistentVarException, UnknownVariableException
	{
	//	/*synchronized*/ (constrProbl)
	//	{
			
			ConstraintProblem active = constrProbl;
			ConstraintProblem sleeping = new ConstraintProblem();
			Vector appRis=new Vector();
			for(int j=0;j<constrProbl.numberOfVariable();j++)
			{
				sleeping.addVariable(constrProbl.variableAt(j));
			}
			
			while (active.numberOfConstraint()>0)
			{
				BinaryConstraint constr= (BinaryConstraint) active.constraintAt(0);
			
				Variable[] vars=constr.getVariables();
							
				boolean mod1=constr.propagateToRight();
				boolean mod2=constr.propagateToLeft();
				
				if(vars[0].getDomain().isEmpty() || vars[1].getDomain().isEmpty() )
				{	
					for(int k=0;k<sleeping.numberOfConstraint();k++)
					{
						constrProbl.addConstraint(sleeping.constraintAt(k));
					}
	
					throw new NoSolutionException();
				}
				if(mod1)
				{
					awake(vars[0],active,sleeping);
					if(!appRis.contains(vars[0].getName())) appRis.add(vars[0].getName());
				}
				if(mod2)
				{
					awake(vars[1],active,sleeping);
					if(!appRis.contains(vars[1].getName())) appRis.add(vars[1].getName());
				}
			
				asleep(constr,active,sleeping);
			}
			
			for(int i=0;i<sleeping.numberOfConstraint();i++)
			{	
				constrProbl.addConstraint(sleeping.constraintAt(i));
			}
			int dim=appRis.size();
			String[] ris= new String[dim];
			for(int i=0;i<dim;i++)
			{
				ris[i]=(String) appRis.elementAt(i);
			}
			return ris;
			
	//	}	
	
	}

	private void awake(Variable var,ConstraintProblem act,ConstraintProblem slp) throws UnknownVariableException
	{
		for(int i=0;i<slp.numberOfConstraint();i++)
		{
			BinaryConstraint constr = (BinaryConstraint) slp.constraintAt(i);
			Variable[] varsConstr=constr.getVariables();

			if(varsConstr[0].getName().equals(var.getName()) || varsConstr[1].getName().equals(var.getName()))
			{
				act.addConstraint(constr);
				slp.removeConstraint(constr); 
			}
		}
	}
	
	private void asleep(BinaryConstraint constr,ConstraintProblem act,ConstraintProblem slp) throws UnknownVariableException
	{
		slp.addConstraint(constr);
		act.removeConstraint(constr); 
	}



}