/*
 * Domain.java
 *
 * 
 */
 package DisCSP.CSP;

/**
 * @ version 1.0
 *
 * @ author Nocerino Francesca
 *
 * @ since JDK 1.4
 *
 */


import DisCSP.Exception.EmptyDomainException;
import DisCSP.Exception.OutDomainException;

public class Domain
{
	private DomainVector dom;

 	/** Costruttore di Domain
     * 
     * 
     */
	public Domain ()
	{
		dom=new DomainVector();
	}
	
/*	public Domain (Domain d)
	{
		super();
		try
		{		
			for(int i=0;i<d.cardinality();i++)
			{
				addValue(d.valueAt(i));
			}
		}
		catch (OutDomainException e)
		{
		}
		
	}
*/

 	/** Costruttore di Domain
     * 
     * @param v l'elemento del dominio
     * 
     */
	public Domain (int v)
	{
		dom=new DomainVector(v);
	}

 	/** Costruttore di Domain
     * 
     * @param min l'estremo inferiore del dominio
     * @param max l'estremo superiore del dominio
     * 
     */	
	public Domain (int min, int max)
	{
		dom=new DomainVector(min, max);
	}
	
	 /**  Aggiunge un intero al dominio
     * 
	 * @param v il numero intero
     * 
     */
	public  void addValue(int v)
	{
		dom.addValue(v);
	}
	
	 /** Controlla se il dominio  vuoto 
     * 
     * @return true se il dominio  vuoto, false altrimenti
     * 
     */
	
	public  boolean isEmpty()
	{
		if(cardinality()==0) return true;
		return false;
	}
	
	 /** Aggiunge al dominio un intervallo di cui sono specificati l'estremo inferiore e l'estremo superiore
     * 
	 * @param min l'estremo inferiore
	 * @param max l'estremo superiore
     * 
     */

	public  void addInterval(int min, int max)
	{
		dom.addInterval(min,max);
	}
	
	 /** Rimuove un valore dal dominio
     * 
	 * @param v l'intero da rimuovere
     * 
     */
	
	public  void removeValue(int v)
	{
		dom.removeValue(v);
	}
	
	 /** Restituisce l'i-esimo valore del dominio
     * 
	 * @param i l'indice
     * @return l'i-esimo valore del dominio
     * 
     */
	
	public  int valueAt(int index) throws OutDomainException
	{
		return dom.valueAt(index);
	}
	
	/** Stampa il dominio
	 *
     * @return una stringa che rappresenta il dominio
     * 
     */		
	
	public  String print()
	{
		return dom.print();
	}
	
	 /**  Controlla se un certo intero  presente nel dominio
     * 
	 * @param val l'intero
     * @return true se val  presente nel dominio, false altrimenti
     * 
     */
	
	public  boolean isPresent(int val)
	{
		return dom.isPresent(val);
	}
	
	 /**  Restituisce la cardinalit del dominio
     * 
     * @return la cardinalit del dominio
     * 
     */
	
	public  int cardinality()
	{
		return dom.cardinality();
	}
	
	 /**  Restituisce il valore pi piccolo appartenente al dominio
     * 
     * @return il valore pi piccolo appartenente al dominio
     * @throws EmptyDomainException
     * 
     */
	
	public  int getMinValue() throws EmptyDomainException
	{
		return dom.getMinValue();		
	}
	
	 /**  Restituisce il valore pi grande appartenente al dominio
     * 
     * @return il valore pi grande appartenente al dominio
     * @throws EmptyDomainException
     * 
     */

	public  int getMaxValue() throws EmptyDomainException
	{
		return dom.getMaxValue();
	}

}





/*	private int min;
	private int max;
	
	public Domain(int i, int j)
	{
		min=i;
		max=j;	
	}
	
	public int getMinVal()
	{
		return min;
	}
	
	public int getMaxVal()
	{
		return max;
	}

	public void setMinVal(int v)
	{
		min=v;
	}
	
	public void setMaxVal(int v)
	{
		max=v;
	}
	
	public int getNextVal(int val)
	{
		if(val<min) return -1;
		if(val>=max) return -1;
		return val+1;
	}

	public int getPrevVal(int val)
	{
		if(val<=min) return -1;
		if(val>max) return -1;
		return val-1;
	}
	*/