/*
 * GreaterConstraint.java
 *
 * 
 */
 package DisCSP.CSP.Constraint;

import DisCSP.CSP.*;
import DisCSP.Exception.*;

/**
 * @ version 1.0
 *
 * @ author Nocerino Francesca
 *
 * @ since JDK 1.4
 *
 */

public class GreaterConstraint implements BinaryConstraint
{
	private Variable var1;
	private Variable var2;
	
	
	/** Costruttore di GreaterConstraint
	 * 
	 * @param v1 la prima variabile coinvolta nel vincolo
	 * @param v2 la seconda variabile coinvolta nel vincolo
	 * 
	 */	
	 	
	public GreaterConstraint(Variable v1, Variable v2) throws NotBinaryConstrException
	{
		if(v1.getName().equals(v2.getName())) throw new NotBinaryConstrException(v1.getName());
		var1=v1;
		var2=v2;
	}
	 
	 /** Verifica, dati due interi v1 e v2, se v1>v2 
     * 
	 * @param v1 il primo intero
	 * @param v2 il secondo intero
     * @return true se v1>v2, false altrimenti
     * 
     */
	public boolean check(int v1, int v2)
	{
		return v1>v2;
	}
	
/*	public BinaryConstraint getCopy()
	{
		return new GreaterConstraint( var1.getCopy(), var2.getCopy());
	}
	*/
	
	 /** Restituisce le due variabili del vincolo
     * 
     * @return le due variabili legate dal vincolo binario
     * 
     */	
	public Variable[] getVariables()
	{
		Variable[] vars= new Variable[2];
		vars[0]= var1;
		vars[1]=var2;
		return vars;
	}
	
	/** Propaga il vincolo verso destra
     * 
     * @return true se il dominio della prima variabile  stato modificato,  false altrimenti
     * 
     */	

	public boolean propagateToRight()
	{
		boolean mod=false;
		try
		{
			Domain d1= var1.getDomain();
			Domain d2= var2.getDomain();
			while(! (d1.getMinValue()>d2.getMinValue()) )
			{
				d1.removeValue(d1.getMinValue());
				mod=true;
			}	
		}		
		catch(EmptyDomainException e)
		{
		}
		return mod;
	}
	
	/** Propaga il vincolo verso sinistra
     * 
     * @return true se il dominio della seconda variabile  stato modificato,  false altrimenti
     * 
     */		

	public boolean propagateToLeft()
	{
		boolean mod=false;
		try
		{
			Domain d1= var1.getDomain();
			Domain d2= var2.getDomain();
			while(! (d2.getMaxValue()<d1.getMaxValue()) )
			{
				d2.removeValue(d2.getMaxValue());
				mod=true;
			}
			
		}		
		catch(EmptyDomainException e)
		{
		}
		return mod;
	}
	
	/** Stampa il vincolo
     * 
     * @return una stringa rappresentante il vincolo
     * 
     */		

	public String print()
	{
		return var1.getName()+">"+var2.getName();
	}

}