/*
 * EqualConstraint.java
 *
 * 
 */
 package DisCSP.CSP.Constraint;

import DisCSP.CSP.*;
import DisCSP.Exception.*;

/**
 * @ version 1.0
 *
 * @ author Nocerino Francesca
 *
 * @ since JDK 1.4
 *
 */

public class EqualConstraint implements BinaryConstraint
{
	private Variable var1;
	private Variable var2;
	
	/** Costruttore di EqualConstraint
	 * 
	 * @param v1 la prima variabile coinvolta nel vincolo
	 * @param v2 la seconda variabile coinvolta nel vincolo
	 * 
	 */	
	public EqualConstraint(Variable v1, Variable v2) throws NotBinaryConstrException
	{
		if(v1.getName().equals(v2.getName())) throw new NotBinaryConstrException(v1.getName());
		var1=v1;
		var2=v2;
	}
	
	 	
 	/** Verifica, dati due interi v1 e v2, se v1==v2 
     * 
	 * @param v1 il primo intero
	 * @param v2 il secondo intero
     * @return true se v1==v2, false altrimenti
     * 
     */

	public boolean check(int v1, int v2)
	{
		return v1==v2;
	}
	
/*	public BinaryConstraint getCopy()
	{
		return new EqualConstraint( var1.getCopy(), var2.getCopy());
	}
*/

	 	
 	/** Restituisce le due variabili del vincolo
     * 
     * @return le due variabili legate dal vincolo binario
     * 
     */	
	public Variable[] getVariables()
	{
		Variable[] vars= new Variable[2];
		vars[0]= var1;
		vars[1]=var2;
		return vars;
	}
	
	 /** Propaga il vincolo verso destra
     * 
     * @return true se il dominio della prima variabile  stato modificato,  false altrimenti
     * 
     */	
	public boolean propagateToRight()
	{
		boolean mod=false;
		try
		{	
			Domain d1= var1.getDomain();
			Domain d2= var2.getDomain();
			
			for(int i=0;i<d1.cardinality();i++)
			{
				int val=d1.valueAt(i);
				if (!d2.isPresent(val))
				{
					d1.removeValue(val);
					i--;
					mod=true;
				}
			}
			
		}
		catch(OutDomainException e)
		{
		}
		return mod;
	}
	
	 /** Propaga il vincolo verso sinistra
     * 
     * @return true se il dominio della seconda variabile  stato modificato,  false altrimenti
     * 
     */		
	public boolean propagateToLeft()
	{
		boolean mod=false;
		try
		{
			
			Domain d1= var1.getDomain();
			Domain d2= var2.getDomain();
			for(int i=0;i<d2.cardinality();i++)
			{
				int val=d2.valueAt(i);
				if (!d1.isPresent(val))
				{
					d2.removeValue(val);
					i--;
					mod=true;
				}
			}
		}		
		catch(OutDomainException e)
		{
		}
		return mod;
	}
	
	 /** Stampa il vincolo
     * 
     * @return una stringa rappresentante il vincolo
     * 
     */		
	public String print()
	{
		return var1.getName()+"="+var2.getName();
	}

}