/*
 * TestReteFin.java
 *
 * Created on 21 aprile 2004, 11.54
 */

package Src.Test;

/**
 *
 * @author  Monaco Luca
 */

import Src.Servizi.NetworkSupport.*;
import java.net.*;
import java.io.*;
import java.util.*;
import Src.Logica.*;
import Src.Servizi.ServiziXML.LibreriaDOM.*;
import org.xml.sax.SAXException;
import javax.xml.parsers.*;
import org.apache.xml.serialize.*;
import Src.Servizi.Exception.*;
import Src.LogicaDistribuito.*;

public class TestReteFin extends Thread{
    
    /** Creates a new instance of TestReteFin */
    public TestReteFin() {
    }
    
    public static void main(String[] args)
    throws UnknownHostException, IOException, InterruptedException, ClassNotFoundException, 
           FileNotFoundException, ParserConfigurationException, SAXException,ElementNotFoundException, AttributeNotFoundException
    
    {
        int nNodi= 4;
        int tempoMax = 11000;
        int tokenTimeout = (nNodi+1)*tempoMax;
        int port = 2000;
        Random r = new Random();
        NodoClassificatore[] nodi = new NodoClassificatore[nNodi+1];
        nodi[0] = new NodoClassificatore(port);
        nodi[0].setTokenTimeout(tokenTimeout);
        int j=0;
        for(int i=0;i<nNodi;i++){
           int t= r.nextInt(1000); 
           sleep(t);
           nodi[i+1] = (NodoClassificatore)nodi[i].addInNet();
           nodi[i+1].setTokenTimeout(tokenTimeout);
        }
        
        String nomeFile="c:/progetti/Classificatore/TrainingSet2.xml";
        DocumentHandler dh = new DocumentHandler(nomeFile);
        TrainingSet ts  =(TrainingSet)dh.loadElementFromXML("elenco","id","1");
        
        System.out.println();
        System.out.println();
        for(int i=0;i<nNodi+1;i++){
            System.out.println(nodi[i]);
        }
        
        /*------------------- Comportamento in situazione normale -----------------------------------*/
        int nEsempiDaUsare = ts.getSize()/2;
        int k1=0;
        for (int k=0;k<nEsempiDaUsare;k++,k1++){
            int i,t;
            do {i = r.nextInt(nNodi);}
            while(i<0);
            do {t = r.nextInt(4000);}
            while(t<0);
            sleep(t);
            nodi[i].receivedUpdateRequest(new UpdateRequest(ts.getEsempio(k)));
            System.out.println();
        }
        /*--------------------- Comportamento con richieste di classificazione-------------------*/
        for (int k=k1;k<ts.getSize();k++){
            int i,t;
            do {i = r.nextInt(nNodi);}
            while(i<0);
            do {t = r.nextInt(1000);}
            while(t<0);
            sleep(t);
            nodi[i].receivedClassifyRequest(new ClassifyRequest(ts.getEsempio(k).getIstanza()));
            System.out.println();
        }
        
        /*------------------- Comportamento con caduta di un nodo senza token-----------------------*/
        //sleep(10000);
        //nodi[3].simulaFailSenzaToken();
        
        /*------------------- Comportamento con caduta di un nodo con token-----------------------*/
        //sleep(4000);
        //nodi[1].receivedFailRequest(new FailRequest());
    }
}
